% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account.R
\name{etrd_alert_detail}
\alias{etrd_alert_detail}
\title{ETrade Alert Details}
\usage{
etrd_alert_detail(
  alertId,
  access_tokens = NULL,
  etrade_cred = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{alertId}{An alert id that comes from \code{\link{etrd_alerts}}}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
the alert details in list form
}
\description{
Get the details for a specific alert based on the alert ID
}
\examples{
\dontrun{

# Get an alert detail for a specific account and alert
account_id = etrd_account_list()$accountIdKey[1]
alert_id = etrd_alerts(account_id)$id[1]
etrd_alert_detail(alert_id)

}
}
