% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.euler.R
\name{panel.euler.ellipses}
\alias{panel.euler.ellipses}
\title{Panel Function for Euler Ellipses}
\usage{
panel.euler.ellipses(x, y, ra, rb, phi, border = "black",
  fill = "transparent", n = 200, ..., identifier = NULL,
  name.type = "panel", col, font, fontface)
}
\arguments{
\item{x}{X coordinates for the centers.}

\item{y}{Y coordinates for the centers.}

\item{ra}{Semi-major axes.}

\item{rb}{Semi-minor axes.}

\item{phi}{Rotation of the ellipse (as the counter-clockwise angle from
the positive x-axis to the semi-major axis).}

\item{border}{Border color.}

\item{fill}{Ellipse fill.}

\item{n}{Number of vertices to draw for each ellipse.}

\item{...}{Passed on to \code{\link[grid:grid.polygon]{grid::grid.polygon()}}.}

\item{identifier}{A character string that is prepended to the name of the
grob that is created.}

\item{name.type}{A character value indicating whether the name of the grob
should have panel or strip information added to it. Typically either
\code{"panel"}, \code{"strip"}, \code{"strip.left"}, or \code{""} (for no extra information).}

\item{col}{Ignored}

\item{font}{Ignored}

\item{fontface}{Ignored}
}
\value{
Plots ellipses inside a trellis panel.
}
\description{
Panel Function for Euler Ellipses
}
\seealso{
\code{\link[grid:grid.polygon]{grid::grid.polygon()}}.
}
