% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_search.r
\name{epmc_search_}
\alias{epmc_search_}
\title{Get one page of results when searching Europe PubMed Central}
\usage{
epmc_search_(query = NULL, limit = 100, output = "parsed",
  page_token = NULL, sort = NULL, ...)
}
\arguments{
\item{query}{character, search query. For more information on how to
build a search query, see \url{http://europepmc.org/Help}}

\item{limit}{integer, limit the number of records you wish to retrieve.
By default, 25 are returned.}

\item{output}{character, what kind of output should be returned. One of 'parsed', 'id_list'
or 'raw' As default, parsed key metadata will be returned as data.frame.
'id_list returns a list of IDs and sources.
Use 'raw' to get full metadata as list. Please be aware that these lists
can become very large.}

\item{page_token}{cursor marking the page}

\item{sort}{character, sort results by order (\code{asc}, \code{desc}) and
sort field (e.g. \code{CITED}, \code{P_PDATE}), seperated with a blank.
For example, sort results  by times cited in descending order:
\code{sort = 'CITED desc'}.}

\item{...}{further params from \code{\link{epmc_search}}}
}
\description{
In general, use \code{\link{epmc_search}} instead. It calls this function, calling all
pages within the defined limit.
}
\seealso{
\link{epmc_search}
}

