% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gpdProfShape.R
\name{gpdProfShape}
\alias{gpdProfShape}
\title{GPD Shape Parameter Profile Likelihood Estimation}
\usage{
gpdProfShape(z, conf = 0.95, opt = c("Nelder-Mead", "SANN", "BFGS", "CG",
  "L-BFGS-B", "Brent"))
}
\arguments{
\item{z}{A class object returned from gpdFit.}

\item{conf}{Confidence level to use. Defaults to 95 percent.}

\item{opt}{Optimization method to maximize the profile likelihood, passed to optim. The default method is Nelder-Mead.}
}
\value{
\item{Estimate}{Estimated shape parameter.}
\item{CI}{Profile likelihood based confidence interval for the shape parameter.}
\item{ConfLevel}{The confidence level used.}
}
\description{
Computes the profile likelihood based confidence interval for the shape parameter of the generalized pareto model.
}
\examples{
x <- rgpd(500, loc = 0, scale = 1, shape = 0.25)
z <- gpdFit(x, threshold = 0)
gpdProfShape(z)
}

