% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUPECcv.R
\name{AUPECcv}
\alias{AUPECcv}
\title{Estimation of the Area Under Prescription Evaluation Curve (AUPEC) in Randomized Experiments Under Cross Validation}
\usage{
AUPECcv(Tr, tau, Y, ind, centered = TRUE)
}
\arguments{
\item{Tr}{A vector of the unit-level binary treatment receipt variable for each sample.}

\item{tau}{A matrix where the \code{i}th column is the unit-level continuous score for treatment assignment generated in the \code{i}th fold.}

\item{Y}{The outcome variable of interest.}

\item{ind}{A vector of integers (between 1 and number of folds inclusive) indicating which testing set does each sample belong to.}

\item{centered}{If \code{TRUE}, the outcome variables would be centered before processing. This minimizes
the variance of the estimator. Default is \code{TRUE}.}
}
\value{
A list that contains the following items: \item{aupec}{The estimated
AUPEC.} \item{sd}{The estimated standard deviation
of AUPEC.}
}
\description{
This function estimates AUPEC. The details of the methods for this design are given in Imai and Li (2019).
}
\examples{
Tr = c(1,0,1,0,1,0,1,0)
tau = matrix(c(0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,-0.5,-0.3,-0.1,0.1,0.3,0.5,0.7,0.9),nrow = 8, ncol = 2)
Y = c(4,5,0,2,4,1,-4,3)
ind = c(rep(1,4),rep(2,4))
aupeclist <- AUPECcv(Tr, tau, Y, ind)
aupeclist$aupec
aupeclist$sd
}
\references{
Imai and Li (2019). \dQuote{Experimental Evaluation of Individualized Treatment Rules},
}
\author{
Michael Lingzhi Li, Operations Research Center, Massachusetts Institute of Technology
\email{mlli@mit.edu}, \url{http://mlli.mit.edu};
}
\keyword{evaluation}
