% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dweibullgpdcon.r
\name{weibullgpdcon}
\alias{weibullgpdcon}
\alias{dweibullgpdcon}
\alias{pweibullgpdcon}
\alias{qweibullgpdcon}
\alias{rweibullgpdcon}
\alias{dweibullgpdcon}
\alias{weibullgpdcon}
\alias{pweibullgpdcon}
\alias{qweibullgpdcon}
\alias{rweibullgpdcon}
\alias{pweibullgpdcon}
\alias{weibullgpdcon}
\alias{dweibullgpdcon}
\alias{qweibullgpdcon}
\alias{rweibullgpdcon}
\alias{qweibullgpdcon}
\alias{weibullgpdcon}
\alias{dweibullgpdcon}
\alias{pweibullgpdcon}
\alias{rweibullgpdcon}
\alias{rweibullgpdcon}
\alias{weibullgpdcon}
\alias{dweibullgpdcon}
\alias{pweibullgpdcon}
\alias{qweibullgpdcon}
\title{Weibull Bulk and GPD Tail Extreme Value Mixture Model with Single Continuity Constraint}
\usage{
dweibullgpdcon(x, wshape = 1, wscale = 1, u = qweibull(0.9, wshape,
  wscale), xi = 0, phiu = TRUE, log = FALSE)

pweibullgpdcon(q, wshape = 1, wscale = 1, u = qweibull(0.9, wshape,
  wscale), xi = 0, phiu = TRUE, lower.tail = TRUE)

qweibullgpdcon(p, wshape = 1, wscale = 1, u = qweibull(0.9, wshape,
  wscale), xi = 0, phiu = TRUE, lower.tail = TRUE)

rweibullgpdcon(n = 1, wshape = 1, wscale = 1, u = qweibull(0.9, wshape,
  wscale), xi = 0, phiu = TRUE)
}
\arguments{
\item{x}{quantiles}

\item{wshape}{Weibull shape (positive)}

\item{wscale}{Weibull scale (positive)}

\item{u}{threshold}

\item{xi}{shape parameter}

\item{phiu}{probability of being above threshold \eqn{[0, 1]} or \code{TRUE}}

\item{log}{logical, if TRUE then log density}

\item{q}{quantiles}

\item{lower.tail}{logical, if FALSE then upper tail probabilities}

\item{p}{cumulative probabilities}

\item{n}{sample size (positive integer)}
}
\value{
\code{\link[evmix:weibullgpdcon]{dweibullgpdcon}} gives the density, 
\code{\link[evmix:weibullgpdcon]{pweibullgpdcon}} gives the cumulative distribution function,
\code{\link[evmix:weibullgpdcon]{qweibullgpdcon}} gives the quantile function and 
\code{\link[evmix:weibullgpdcon]{rweibullgpdcon}} gives a random sample.
}
\description{
Density, cumulative distribution function, quantile function and
  random number generation for the extreme value mixture model with Weibull for bulk
  distribution upto the threshold and conditional GPD above threshold with continuity at threshold. The parameters
  are the weibull shape \code{wshape} and scale \code{wscale}, threshold \code{u}
  GPD shape \code{xi} and tail fraction \code{phiu}.
}
\details{
Extreme value mixture model combining Weibull distribution for the bulk
below the threshold and GPD for upper tail with continuity at threshold.

The user can pre-specify \code{phiu} 
permitting a parameterised value for the tail fraction \eqn{\phi_u}. Alternatively, when
\code{phiu=TRUE} the tail fraction is estimated as the tail fraction from the
weibull bulk model.

The cumulative distribution function with tail fraction \eqn{\phi_u} defined by the
upper tail fraction of the Weibull bulk model (\code{phiu=TRUE}), upto the 
threshold \eqn{0 < x \le u}, given by:
\deqn{F(x) = H(x)}
and above the threshold \eqn{x > u}:
\deqn{F(x) = H(u) + [1 - H(u)] G(x)}
where \eqn{H(x)} and \eqn{G(X)} are the Weibull and conditional GPD
cumulative distribution functions (i.e. \code{pweibull(x, wshape, wscale)} and
\code{pgpd(x, u, sigmau, xi)}) respectively.

The cumulative distribution function for pre-specified \eqn{\phi_u}, upto the
threshold \eqn{0 < x \le u}, is given by:
\deqn{F(x) = (1 - \phi_u) H(x)/H(u)}
and above the threshold \eqn{x > u}:
\deqn{F(x) = \phi_u + [1 - \phi_u] G(x)}
Notice that these definitions are equivalent when \eqn{\phi_u = 1 - H(u)}.

The continuity constraint means that \eqn{(1 - \phi_u) h(u)/H(u) = \phi_u g(u)}
where \eqn{h(x)} and \eqn{g(x)} are the Weibull and conditional GPD
density functions (i.e. \code{dweibull(x, wshape, wscale)} and
\code{dgpd(x, u, sigmau, xi)}) respectively. The resulting GPD scale parameter is then:
\deqn{\sigma_u = \phi_u H(u) / [1 - \phi_u] h(u)}.
In the special case of where the tail fraction is defined by the bulk model this reduces to
\deqn{\sigma_u = [1 - H(u)] / h(u)}.

The Weibull is defined on the non-negative reals, so the threshold must be positive.

See \code{\link[evmix:gpd]{gpd}} for details of GPD upper tail component and 
\code{\link[stats:Weibull]{dweibull}} for details of weibull bulk component.
}
\note{
All inputs are vectorised except \code{log} and \code{lower.tail}.
The main inputs (\code{x}, \code{p} or \code{q}) and parameters must be either
a scalar or a vector. If vectors are provided they must all be of the same length,
and the function will be evaluated for each element of vector. In the case of 
\code{\link[evmix:weibullgpdcon]{rweibullgpdcon}} any input vector must be of length \code{n}.

Default values are provided for all inputs, except for the fundamentals 
\code{x}, \code{q} and \code{p}. The default sample size for 
\code{\link[evmix:weibullgpdcon]{rweibullgpdcon}} is 1.

Missing (\code{NA}) and Not-a-Number (\code{NaN}) values in \code{x},
\code{p} and \code{q} are passed through as is and infinite values are set to
\code{NA}. None of these are not permitted for the parameters.

Error checking of the inputs (e.g. invalid probabilities) is carried out and
will either stop or give warning message as appropriate.
}
\section{Acknowledgments}{
 Thanks to Ben Youngman, Exeter University, UK for reporting a bug in the \code{\link[evmix:weibullgpdcon]{rweibullgpdcon}} function.
}

\examples{
\dontrun{
set.seed(1)
par(mfrow = c(2, 2))

x = rweibullgpdcon(1000)
xx = seq(-0.1, 6, 0.01)
hist(x, breaks = 100, freq = FALSE, xlim = c(-1, 6))
lines(xx, dweibullgpdcon(xx))

# three tail behaviours
plot(xx, pweibullgpdcon(xx), type = "l")
lines(xx, pweibullgpdcon(xx, xi = 0.3), col = "red")
lines(xx, pweibullgpdcon(xx, xi = -0.3), col = "blue")
legend("bottomright", paste("xi =",c(0, 0.3, -0.3)),
  col=c("black", "red", "blue"), lty = 1)

x = rweibullgpdcon(1000, phiu = 0.2)
hist(x, breaks = 100, freq = FALSE, xlim = c(-1, 6))
lines(xx, dweibullgpdcon(xx, phiu = 0.2))

plot(xx, dweibullgpdcon(xx, xi=0, phiu = 0.2), type = "l")
lines(xx, dweibullgpdcon(xx, xi=-0.2, phiu = 0.2), col = "red")
lines(xx, dweibullgpdcon(xx, xi=0.2, phiu = 0.2), col = "blue")
legend("topright", c("xi = 0", "xi = 0.2", "xi = -0.2"),
  col=c("black", "red", "blue"), lty = 1)
}

}
\references{
\url{http://en.wikipedia.org/wiki/Weibull_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Behrens, C.N., Lopes, H.F. and Gamerman, D. (2004). Bayesian analysis of extreme
events with threshold estimation. Statistical Modelling. 4(3), 227-244.
}
\seealso{
\code{\link[evmix:gpd]{gpd}} and \code{\link[stats:Weibull]{dweibull}}

Other weibullgpd weibullgpdcon fweibullgpd fweibullgpdcon: \code{\link{weibullgpd}}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
