% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TestModularity.R
\name{TestModularity}
\alias{CreateHipotMatrix}
\alias{TestModularity}
\title{Test modularity hypothesis}
\usage{
TestModularity(cor.matrix, modularity.hipot, permutations = 100,
  MHI = FALSE)

CreateHipotMatrix(modularity.hipot)
}
\arguments{
\item{cor.matrix}{Correlation matrix}

\item{modularity.hipot}{Matrix of hypothesis. Each line represents a trait and each column a module.
if modularity.hipot[i,j] == 1, trait i is in module j.}

\item{permutations}{Number of permutations, to be passed to MantelCor}

\item{MHI}{Indicates if test should use Modularity Hypothesis Index instead of AVG Ratio}
}
\value{
Returns mantel correlation and associated probability for each modularity hypothesis, along with AVG+, AVG-, AVG Ratio for each module.
A total hypothesis combining all hypotesis is also tested.
}
\description{
Tests modularity hypothesis using cor.matrix matrix and trait groupings
}
\examples{
cor.matrix <- RandomMatrix(10)
rand.hipots <- matrix(sample(c(1, 0), 30, replace=TRUE), 10, 3)
mod.test <- TestModularity(cor.matrix, rand.hipots)

cov.matrix <- RandomMatrix(10, 1, 1, 10)
cov.mod.test <- TestModularity(cov.matrix, rand.hipots, MHI = TRUE)
nosize.cov.mod.test <- TestModularity(RemoveSize(cov.matrix), rand.hipots, MHI = TRUE)
}
\author{
Diogo Melo, Guilherme Garcia
}
\references{
Porto, Arthur, Felipe B. Oliveira, Leila T. Shirai, Valderes Conto, and Gabriel Marroig. 2009. "The Evolution of Modularity in the Mammalian Skull I: Morphological Integration Patterns and Magnitudes." Evolutionary Biology 36 (1): 118-35. doi:10.1007/s11692-008-9038-3.
}
\seealso{
\code{\link{MantelCor}}
}
\keyword{mantel}
\keyword{modularity}

