% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{importExcelData}
\alias{importExcelData}
\title{Import Excel Data based on the specifications in a data dictionary}
\usage{
importExcelData(
  excelFile,
  dictionarySheet = "DataDictionary",
  dataSheet = "DataEntry",
  id,
  saveWarnings = TRUE,
  setErrorsMissing = TRUE,
  range,
  colnames,
  origin,
  timeUnit = "month"
)
}
\arguments{
\item{excelFile}{path and filename of the data file containing the data and dictionary}

\item{dictionarySheet}{name of the sheet containing the data dictionary, defaults to 'DataDictionary'}

\item{dataSheet}{name of the data entry sheet within the file, defaults to 'DataEntry'}

\item{id}{String indicating the ID variable, to display errors by ID instead of row number}

\item{saveWarnings}{Boolean, if TRUE and there are any warnings then the function will return a list with the data frame and the import warnings}

\item{setErrorsMissing}{Boolean, if TRUE all values out of range will be set to NA}

\item{range}{Optional, Range of Excel sheet to restrict import to (ie. range="A1:F6")}

\item{colnames}{Optional, Column names of the dictionary,
defaults to those used in the Excel template:
 c('VariableName', 'Description (optional)', 'Type', 'Minimum', 'Maximum', 'Levels')}

\item{origin}{Optional, the date origin of Excel dates, defaults to 30 December 1899}

\item{timeUnit}{Character specifying the unit of time that should be used
when creating survival type variables. Allowed values are from lubridate (ex: 'day' 'week' 'month' 'year')}
}
\value{
A list containing two data frames: the data dictionary and the data table
\itemize{
  \item dictionary - A data frame with entries for each variable
  \item data - A data frame containing the imported data
}
}
\description{
This function reads in a data dictionary and data entry table and converts
code and category variables to factors as outlined in the dictionary. See the
examples.
}
\details{
The exceldata package was designed around the DataDictionary.xlsm template.
More documentation and the current downloadable template can be found at:

https://github.com/biostatsPMH/exceldata#readme
Warning: If SetErrorsMissing = TRUE then a subsequent call to checkData will not return any errors, because the errors have been set to missing.

NOTE: This function will only read in those columns present in the DataDictionary
}
\examples{
exampleDataFile <- system.file("extdata", "exampleData.xlsx", package = "exceldata")
import <- importExcelData(exampleDataFile,
dictionarySheet = 'DataDictionary',dataSheet = 'DataEntry')

# The imported data dictionary
dictionary <- import$dictionary
head(dictionary)

# The imported data, with calculated variables
data <- import$data
head(data)

# Simple univariate plots with outliers
plots <- plotVariables(data=data,dictionary=dictionary,IDvar = 'ID')

}
