/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization;

import org.apache.commons.math3.optimization.AbstractConvergenceChecker;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleValueChecker
extends AbstractConvergenceChecker<PointValuePair> {
    public SimpleValueChecker() {
    }

    public SimpleValueChecker(double relativeThreshold, double absoluteThreshold) {
        super(relativeThreshold, absoluteThreshold);
    }

    @Override
    public boolean converged(int iteration, PointValuePair previous, PointValuePair current) {
        double size;
        double c;
        double p = (Double)previous.getValue();
        double difference = FastMath.abs(p - (c = ((Double)current.getValue()).doubleValue()));
        return difference <= (size = FastMath.max(FastMath.abs(p), FastMath.abs(c))) * this.getRelativeThreshold() || difference <= this.getAbsoluteThreshold();
    }
}

