% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8.1-pipe.R
\docType{methods}
\name{pipeFilter}
\alias{pipeFilter}
\alias{pipeFilter,ExprsPipeline-method}
\title{Filter \code{ExprsPipeline} Object}
\usage{
pipeFilter(object, colBy, how = 0, gate = 0, top = 0)

\S4method{pipeFilter}{ExprsPipeline}(object, colBy, how = 0, gate = 0,
  top = 0)
}
\arguments{
\item{object}{An \code{\link{ExprsPipeline-class}} object.}

\item{colBy}{A character vector or string. Specifies column(s) to use when
filtering by classifier performance. Listing multiple columns will result
in a filter based on a performance metric equal to the product of those
listed columns.}

\item{how, gate}{A numeric scalar. Arguments between 0 and 1 will impose
a threshold or ceiling filter, respectively, based on the raw value of
\code{colBy}. Arguments between 1 and 100 will impose a filter based on
the percentile of \code{colBy}. The user may also provide "midrange",
"median", or "mean" as an argument for these filters. Set \code{how = 0}
or \code{gate = 0}, to skip the threshold or ceiling filter,
respectively.}

\item{top}{A numeric scalar. Determines the top N models based on
\code{colBy} to include after the threshold and ceiling filters.
In the case that the \code{@summary} slot contains the column
"boot", this determines the top N models for each unique bootstrap.
Set \code{top = 0} to skip this subset.}
}
\value{
An \code{\link{ExprsPipeline-class}} object.
}
\description{
\code{pipeFilter} subsets an \code{ExprsPipeline} object.
}
\details{
The filter process occurs in three steps. However, the user may skip
 any one of these steps by setting the respective argument to \code{0}.

First, a threshold filter gets imposed. Any model with a performance
 less than the threshold filter, \code{how}, gets excluded. Second,
 a ceiling filter gets imposed. Any model with a performance less
 than the ceiling filter, \code{gate}, gets excluded. Third, an
 arbitrary subset occurs. The top N models in the \code{ExprsPipeline}
 object get selected based on the argument \code{top}. However,
 in the case that the \code{@summary} slot contains the column
 "boot", \code{pipeFilter} selects the top N models for each unique
 bootstrap.

\code{pipeFilter} will apply this filter for one or more performance
 metrics listed in the \code{colBy} argument. Listing multiple columns
 will result in a filter based on a performance metric equal to the
 product of all listed performance metrics. To more heavily weigh
 one performance metric over another, consider listing that column
 more than once.
}
\section{Methods (by class)}{
\itemize{
\item \code{ExprsPipeline}: Method to filter \code{ExprsPipeline} objects.
}}

\seealso{
\code{\link{pipeFilter}}\cr
\code{\link{pipeUnboot}}\cr
\code{\link{plCV}}\cr
\code{\link{plGrid}}\cr
\code{\link{plGridMulti}}\cr
\code{\link{plMonteCarlo}}\cr
\code{\link{plNested}}
}
