% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_pubchem.R
\name{extr_pubchem_fema}
\alias{extr_pubchem_fema}
\title{Extract FEMA from PubChem}
\usage{
extr_pubchem_fema(casrn)
}
\arguments{
\item{casrn}{A vector of CAS Registry Numbers (CASRN) as atomic vectors.}
}
\value{
A data frame containing the FEMA flavor profile information for each CASRN. If no information is found for a particular CASRN, the output will include a row indicating this.
}
\description{
This function retrieves FEMA (Flavor and Extract Manufacturers Association) flavor profile information for a list of CAS Registry Numbers (CASRN) from the PubChem database using the \code{webchem} package. It applies the function \code{extr_fema_pubchem_} to each CASRN in the input vector and combines the results into a single data frame.
}
\examples{
\donttest{
extr_pubchem_fema(c("64-17-5", "50-00-0"))
}
}
\seealso{
\href{https://pubchem.ncbi.nlm.nih.gov/}{PubChem}
}
