% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res.R
\name{res_binom}
\alias{res_binom}
\title{Binomial Residuals}
\usage{
res_binom(x, size = 1, prob = 0.5, type = "dev", simulate = FALSE)
}
\arguments{
\item{x}{A non-negative whole numeric vector of values.}

\item{size}{A non-negative whole numeric vector of the number of trials.}

\item{prob}{A numeric vector of values between 0 and 1 of the probability of success.}

\item{type}{A string of the residual type. 'raw' for raw residuals 'dev' for deviance residuals and 'data' for the data.}

\item{simulate}{A flag specifying whether to simulate residuals.}
}
\value{
An numeric vector of the corresponding residuals.
}
\description{
Binomial Residuals
}
\examples{
res_binom(c(0, 1, 2), 2, 0.3)
}
\seealso{
Other res_dist: 
\code{\link{res_bern}()},
\code{\link{res_beta_binom}()},
\code{\link{res_gamma_pois_zi}()},
\code{\link{res_gamma_pois}()},
\code{\link{res_gamma}()},
\code{\link{res_lnorm}()},
\code{\link{res_neg_binom}()},
\code{\link{res_norm}()},
\code{\link{res_pois_zi}()},
\code{\link{res_pois}()},
\code{\link{res_student}()}
}
\concept{res_dist}
