% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{bandwidth.CV}
\alias{bandwidth.CV}
\title{Choice of the bandwidth by cross validation.}
\usage{
bandwidth.CV(X, t, Tgrid, hgrid, pcv = 0.99, kernel = TruncGauss.kernel,
  kpar = NULL, CritVal = 3.6, plot = FALSE)
}
\arguments{
\item{X}{a vector of the observed values.}

\item{t}{a vector of time covariates which should have the same length as X.}

\item{Tgrid}{a sequence of times used to perform the cross validation (can be any sequence in the interval \code{[min(t) , max(t)]} ).}

\item{hgrid}{a sequence of values from which the bandwidth is selected.}

\item{pcv}{a probability value which determines the level of quantiles used to perform the cross validation, with default 0.99.}

\item{kernel}{a kernel function used to compute the weights in the time domain, with default the truncated gaussian kernel.}

\item{kpar}{a value for the kernel function parameter, with no default value.}

\item{CritVal}{a critical value associated to the kernel function computed from the function \code{CriticalValue}, with default 3.6 corresponding to the truncated Gaussian kernel.}

\item{plot}{If \code{TRUE}, the cross validation function is plotted.}
}
\value{
\item{hgrid}{the sequence of bandwidth given in input.}
\item{CV}{the values of the cross validation function for \code{hgrid}.}
\item{h.cv}{the bandwidth that minimizes the cross-validation function.}
}
\description{
Choose a bandwidth by minimizing the cross validation function.
}
\details{
The sequence \eqn{hgrid} must be geometric. (see \code{\link{bandwidth.grid}} to generate a geometric grid of bandwidths).

The value \eqn{pcv} should be scalar (vector values are not admitted).
}
\examples{
#Generate the data
theta <- function(t){
   0.5+0.25*sin(2*pi*t)
 }
n <- 5000
t <- 1:n/n
Theta <- theta(t)
Data <- NULL
for(i in 1:n){
   Data[i] <- rparetomix(1, a = 1/Theta[i], b = 1/Theta[i]+5, c = 0.75)
 }

#compute the cross validation bandwidth
Tgrid <- seq(0, 1, 0.02) #define a grid to perform the cross validation
hgrid <- bandwidth.grid(0.1, 0.3, 20) #define a grid of bandwidths
\dontrun{ #For computation time purpose
  Hcv <- bandwidth.CV(Data, t, Tgrid, hgrid, pcv = 0.99, plot = TRUE)
  #The computing time can be long
  Hcv
}


}
\author{
Durrieu, G., Grama, I., Jaunatre, K., Pham, Q. and Tricot, J.- M
}
\references{
Durrieu, G. and Grama, I. and Pham, Q. and Tricot, J.- M (2015). Nonparametric adaptive estimator of extreme conditional tail probabilities quantiles. Extremes, 18, 437-478.
}
\seealso{
\code{\link{bandwidth.grid}} , \code{\link{CriticalValue}}
}

