% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radf_mc.R
\name{radf_mc_cv}
\alias{radf_mc_cv}
\alias{radf_mc_distr}
\title{Monte Carlo Critical Values}
\usage{
radf_mc_cv(n, minw = NULL, nrep = 1000L, seed = NULL)

radf_mc_distr(n, minw = NULL, nrep = 1000L, seed = NULL)
}
\arguments{
\item{n}{A positive integer. The sample size.}

\item{minw}{A positive integer. The minimum window size (default =
\eqn{(0.01 + 1.8/\sqrt(T))T}{(0.01 + 1.8 / \sqrtT)T}, where T denotes the sample size).}

\item{nrep}{A positive integer. The number of Monte Carlo simulations.}

\item{seed}{An object specifying if and how the random number generator (rng)
should be initialized. Either NULL or an integer will be used in a call to
\code{set.seed} before simulation. If set, the value is saved as "seed" attribute
of the returned value. The default, NULL, will not change rng state, and
return .Random.seed as the "seed" attribute. Results are different between
the parallel and non-parallel option, even if they have the same seed.}
}
\value{
For \code{radf_mc_cv} a list that contains the critical values for ADF,
BADF, BSADF and GSADF test statistics. For \code{radf_mc_distr} a list that
contains the ADF, SADF and GSADF distributions.
}
\description{
\code{radf_mc_cv} computes Monte Carlo critical values for the recursive unit
root tests. \code{radf_mc_distr} computes the distribution.
}
\examples{
\donttest{
# Default minimum window
mc <- radf_mc_cv(n = 100)

tidy(mc)

# Change the minimum window and the number of simulations
mc2 <- radf_mc_cv(n = 100, nrep = 600, minw = 20)

tidy(mc2)

mdist <- radf_mc_distr(n = 100, nrep = 1000)

autoplot(mdist)
}
}
\seealso{
\code{\link{radf_wb_cv}} for wild bootstrap critical values and
\code{\link{radf_sb_cv}} for sieve bootstrap critical values
}
