% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_ps1}
\alias{sim_ps1}
\title{Simulation of a single-bubble process with multiple forms of collapse regime}
\usage{
sim_ps1(
  n,
  te = 0.4 * n,
  tf = te + 0.2 * n,
  tr = tf + 0.1 * n,
  c = 1,
  c1 = 1,
  c2 = 1,
  eta = 0.6,
  alpha = 0.6,
  beta = 0.5,
  sigma = 6.79,
  seed = NULL
)
}
\arguments{
\item{n}{A positive integer specifying the length of the simulated output series.}

\item{te}{A scalar in (0, tf) specifying the observation in which the bubble originates.}

\item{tf}{A scalar in (te, n) specifying the observation in which the bubble collapses.}

\item{tr}{A scalar in  (tf, n) specifying the observation in which market recovers}

\item{c}{A positive scalar determining the drift in the normal market periods.}

\item{c1}{A positive scalar determining the autoregressive coefficient in the explosive regime.}

\item{c2}{A positive scalar determining the autoregressive coefficient in the collapse regime.}

\item{eta}{A positive scalar (>0.5) determining the drift in the normal market periods.}

\item{alpha}{A positive scalar in (0, 1) determining the autoregressive coefficient in the bubble period.}

\item{beta}{A positive scalar in (0, 1) determining the autoregressive coefficient in the collapse period.}

\item{sigma}{A positive scalar indicating the standard deviation of the innovations.}

\item{seed}{An object specifying if and how the random number generator (rng)
should be initialized. Either NULL or an integer will be used in a call to
\code{set.seed} before simulation. If set, the value is saved as "seed" attribute
of the returned value. The default, NULL, will not change rng state, and
return .Random.seed as the "seed" attribute. Results are different between
the parallel and non-parallel option, even if they have the same seed.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
The new generating process considered here differs from the \code{sim_psy1} model in
three respects - Phillips and Shi (2018):

\emph{First, it includes an asymptotically negligible drift in the martingale
path during normal periods. Second, the collapse process is modeled directly as
a transient mildly integrated process that covers an explicit period of market collapse.
Third, a market recovery date is introduced to capture the return to normal market behavior.
}
\itemize{
\item \verb{sudden:} with \code{beta = 0.1} and \code{tr =  tf + 0.01*n}
\item \verb{disturbing:} with \code{beta = 0.5} and \code{tr =  tf + 0.1*n}
\item \verb{smooth:} with \code{beta = 0.9} and \code{tr =  tf + 0.2*n}
}

In order to provide the duration of the collapse period \code{tr} as \verb{tr = tf + 0.2n},
you have to provide \code{tf} as well.
}
\examples{
# Disturbing collapse (default)
disturbing <- sim_ps1(100)
autoplot(disturbing)

# Sudden collapse
sudden <- sim_ps1(100, te = 40, tf= 60, tr = 61, beta = 0.1)
autoplot(sudden)

}
\references{
Phillips, Peter CB, and Shu-Ping Shi. "Financial bubble implosion
and reverse regression." Econometric Theory 34.4 (2018): 705-753.
}
\seealso{
\code{\link{sim_psy1}}
}
