% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.eyeris.R
\name{plot.eyeris}
\alias{plot.eyeris}
\title{Plot pre-processed pupil data from \code{eyeris}}
\usage{
\method{plot}{eyeris}(
  x,
  ...,
  steps = NULL,
  preview_n = NULL,
  preview_duration = NULL,
  preview_window = NULL,
  seed = NULL,
  block = 1,
  plot_distributions = FALSE,
  num_previews = deprecated()
)
}
\arguments{
\item{x}{An object of class \code{eyeris} dervived from \code{\link[=load_asc]{load_asc()}}.}

\item{...}{Additional arguments to be passed to \code{plot}.}

\item{steps}{Which steps to plot; defaults to \code{all} (i.e., plot all steps).
Otherwise, pass in a vector containing the index of the step(s) you want to
plot, with index \code{1} being the original raw pupil timeseries.}

\item{preview_n}{Number of random example "epochs" to generate for
previewing the effect of each preprocessing step on the pupil timeseries.}

\item{preview_duration}{Time in seconds of each randomly selected preview.}

\item{preview_window}{The start and stop raw timestamps used to subset the
preprocessed data from each step of the \code{eyeris} workflow for visualization.
Defaults to NULL, meaning random epochs as defined by \code{preview_n} and
\code{preview_duration} will be plotted. To override the random epochs, set
\code{preview_window} here to a vector with relative start and stop times (in
seconds), for example -- \code{c(5,6)} -- to indicate the raw data from 5-6 secs
on data that were recorded at 1000 Hz). Note, the start/stop time values
indicated here are in seconds because \code{eyeris} automatically computes the
indices for the supplied range of seconds using the \verb{$info$sample.rate}
metadata in the \code{eyeris} S3 class object.}

\item{seed}{Random seed for current plotting session. Leave NULL to select
\code{preview_n} number of random preview "epochs" (of \code{preview_duration}) each
time. Otherwise, choose any seed-integer as you would normally select for
\code{\link[base:Random]{base::set.seed()}}, and you will be able to continue re-plotting the same
random example pupil epochs each time -- which is helpful when adjusting
parameters within and across \code{eyeris} workflow steps.}

\item{block}{For multi-block recordings, specifies which block to plot.
Defaults to 1. When a single \code{.asc} data file contains multiple
recording blocks, this parameter determines which block's timeseries to
visualize. Must be a positive integer not exceeding the total number of
blocks in the recording.}

\item{plot_distributions}{Logical flag to indicate whether to plot both
diagnostic pupil timeseries \emph{and} accompanying histograms of the pupil
samples at each processing step. Defaults to \code{FALSE}.}

\item{num_previews}{\strong{(Deprecated)} Use \code{preview_n} instead.}
}
\value{
No return value; iteratively plots a subset of the pupil timeseries
from each preprocessing step run.
}
\description{
S3 plotting method for objects of class \code{eyeris}. Plots a single-panel
timeseries for a subset of the pupil timeseries at each preprocessing step.
The intended use of this function is to provide a simple method for
qualitatively assessing the consequences of the preprocessing recipe and
parameters on the raw pupillary signal.
}
\examples{
# first, generate the preprocessed pupil data
my_eyeris_data <- system.file("extdata", "memory.asc", package = "eyeris") |>
  eyeris::load_asc() |>
  eyeris::deblink(extend = 50) |>
  eyeris::detransient() |>
  eyeris::interpolate() |>
  eyeris::lpfilt(plot_freqz = TRUE) |>
  eyeris::zscore()

# controlling the timeseries range (i.e., preview window) in your plots:

## example 1: using the default 10000 to 20000 ms time subset
plot(my_eyeris_data, seed = 0)

## example 2: using a custom time subset (i.e., 1 to 500 ms)
plot(my_eyeris_data, preview_window = c(0.01, 0.5), seed = 0)

# controlling which block of data you would like to plot:

## example 1: plots first block (default)
plot(my_eyeris_data, seed = 0)

## example 2: plots a specific block
plot(my_eyeris_data, block = 1, seed = 0)

## example 3: plots a specific block along with a custom preview window
##   (i.e., 1000 to 2000 ms)
plot(
  my_eyeris_data,
  block = 1,
  preview_window = c(1, 2),
  seed = 0
)

}
\seealso{
\code{\link[lifecycle:deprecate_soft]{lifecycle::deprecate_warn()}}
}
