% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{simulate_eyetrackingr_data}
\alias{simulate_eyetrackingr_data}
\title{Simulate an eyetrackingR dataset}
\usage{
simulate_eyetrackingr_data(num_participants = 16,
  num_items_per_condition = 6, trial_length = 5000, pref = 0.5,
  pref_window = c(1, trial_length), noisy_window = NULL, ...)
}
\arguments{
\item{num_participants}{Number of participants}

\item{num_items_per_condition}{Number of trials per-subject per-condition.}

\item{trial_length}{How long is the trial (in ms)?}

\item{pref}{Their preference between the two AOIs in the "high" condition, 
where 1 is 100% preference for AOI1, and 0 is 100% preference for AOI2. Default is .5 (equal 
preference). In the "low" condition, their preference between the two AOIs is equal, so default
is no effect of condition.}

\item{pref_window}{Vector of length two, specifying start and end of time-window in
which participants expressed the preference specified in \code{pref}. Default is the entire trial}

\item{noisy_window}{Vector of length two, specifying start and end of time-window in
which there was substantial trackloss during the trial.}

\item{...}{Ignored}
}
\value{
Dataframe with eye-tracking data
}
\description{
This function creates an eyetrackingR dataset (i.e., already run through make_eyetrackingr_data).
This can be helpful for examining the false-alarm and sensitivity of analysis-techniques via 
simulations.
}

