% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_change.R
\name{insert_change}
\alias{insert_change}
\title{Insert A Change In the Mean Function Of Functional Data}
\usage{
insert_change(fdobj, change_fun = NULL, k = NULL, change_location, SNR,
  plot = TRUE, ...)
}
\arguments{
\item{fdobj}{Functional data object of class \code{'fd'}}

\item{change_fun}{Self defined change function. It has to be a functional data object having the same
number of basis functions.}

\item{k}{Number of basis functions to be summed to construct the change function. It should
be used when \code{change_fun} is not defined. It has to be less than number of basis functions.}

\item{change_location}{Location of the change to be inserted. It is scaled to be in [0,1].}

\item{SNR}{Signal to Noise Ratio to determine the magnitude of the change function that is being
inserted.}

\item{plot}{Plots the functional data before (blue) and after (red) the change.}

\item{...}{Further information to pass}
}
\value{
\code{fundata:} functional data with an inserted change in the mean function

\code{change_fun:} inserted change function

\code{plot:} of the functional data with inserted change
}
\description{
This function inserts a change in the mean function to a given functional data sample. The change function
can either be directly defined by the user or it can be generated based on the sum of first
\code{k} basis functions defined by the \code{fdobj}. Once the change function is defined the change is inserted at the
defined change location with a signal magnitude defined by signal to noise ratio, \code{SNR}.
For more details on how these quantities are defined. See Aue, Rice and Sonmez (2017+).
}
\details{
This function should only be used to artificially insert a change function to the mean of
the functional data set either by defining a specific change function or generating the change function
based from the basis functions.
}
\examples{
####################################
#first generate FAR(1) process
fdata = fun_AR(n=100, nbasis=25, Sigma=2^-(1:25))
# insert the change which is the sum of first 3 basis functions
# in the middle of the data with SNR=2
insert_change(fdata, k=3, change_location=0.5, SNR=2)

####################################
#first generate FAR(1) process
fdata = fun_AR(n=100, nbasis=25, Sigma=2^-(1:25))
# insert the change which is the 20th onservation
# in the middle of the data with SNR=2
insert_change(fdata, change_fun = fdata[20], change_location=0.5, SNR=2)
}
\references{
Ramsay, James O., and Silverman, Bernard W. (2006), \emph{Functional
Data Analysis, 2nd ed.}, Springer, New York.

Aue A., Rice G., Sonmez O. (2017+), \emph{Detecting and dating structural breaks in
functional data without dimension reduction} (https://arxiv.org/pdf/1511.04020.pdf)
}
\seealso{
\code{\link{Data2fd}, \link{fun_IID}, \link{fun_MA}, \link{fun_AR}}
}
