% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-locpol_spec.R
\name{locpol_spec}
\alias{locpol_spec}
\title{Specification of Nonparametric Local Polynomial Models}
\usage{
locpol_spec(
  poly_order = c(3, 1),
  kernel_order = c(1, 0, 2, 3),
  boundary_method = c("extend", "shorten"),
  bwidth = NULL
)
}
\arguments{
\item{poly_order}{a single numeric value, in detail either \code{1}
or \code{3}, that represents the local polynomial order.}

\item{kernel_order}{a single numeric value representing
the smoothness of the underlying kernel function;
available are \code{0} (uniform), \code{1} (epanechnikov),
\code{2} (bisquare), and \code{3} (triweight).}

\item{boundary_method}{a single character value indicating
the smoothing concept to use at boundary points; for
\code{"extend"}, the smoothing window is extended toward the
interior by the amount that is lost toward the boundary; for
\code{"shorten"}, there is no compensation in the smoothing window
toward the interior for the loss of window width toward the boundary,
i.e. the total smoothing window width reduces more and more when
getting closer to the first and last time points.}

\item{bwidth}{the smoothing bandwidth; for NULL, i.e. the default, an automated
bandwidth selection is employed; otherwise a single numeric value between
0 and 0.5 must be provided.}
}
\value{
An object of class \code{"locpol_spec"} is returned.
}
\description{
Specify the nonparametric local polynomial model part in a
semiparametric volatility model.
}
\details{
Assume that a time series \eqn{\{r_t\}}, \eqn{t=1,\dots,n}, follows
\deqn{r_t = \mu + \sigma_t \eta_t,}
where \eqn{\mu = E(r_t)} and \eqn{\eta_t} are independent and identically
distributed random variables with mean zero and variance one. \eqn{\sigma_t > 0}
are total volatilities composed of \eqn{s(x_t)}, a smooth, deterministic
scale function in the unconditional variance over time (with \eqn{x_t} being
the rescaled time on the interval \eqn{[0, 1]}), and of \eqn{\lambda_t},
the conditional standard deviation in \eqn{\zeta_t=\lambda_t\eta_t}, so that
\eqn{\sigma_t = s(x_t)\lambda_t}, or alternatively \eqn{r_t = \mu + s(x_t)\zeta_t}.
It is assumed that the unconditional variance of the \eqn{\zeta_t} is one.

The package's estimation of \eqn{\sigma_t} is based on the following relations:

\eqn{r_t^{*} = r_t - \mu},
\eqn{y_t=\ln\left[\left(r_t^{*}\right)^2\right]},
\eqn{C_{\mu}=E\left[\ln\left(\zeta_t^2\right)\right]},
\eqn{m(x_t) = \ln\left[s^2 (x_t)\right] + C_{\mu}},
\eqn{\xi_t = \ln\left(\zeta_t^2\right) - C_{\mu}}, so that
\deqn{y_t = m(x_t)+\xi_t,}
where \eqn{m} describes a smooth, deterministic trend in \eqn{y_t}.
Nonparametric estimation of \eqn{m} and subsequent retransformation
allows to obtain a suitable estimate of the scale function \eqn{s}
in \eqn{r_t}. Following Feng et al. (2022) and Letmathe et al. (2023),
we employ local polynomial regression with automatically selected
bandwidth (specially for the time-series context). The function
\code{locpol_spec} allows to set the basic characteristics of the
local polynomial estimator considered, like the order of polynomial
used in the local regressions, and the kernel function order. After
the scale function has been estimated, a zero-mean GARCH-type model
can be fitted to the estimated \eqn{\zeta_t}.

Depending on whether \eqn{\zeta_t} is assumed to follow a short-memory
or a long-memory model, the bandwidth selection algorithm in the
local polynomial regression step differs and follows either
Feng et al. (2022) and Letmathe et al. (2023). The algorithm
selection is done automatically based on the remaining model
specifications in the call to the estimation functions like
\code{\link{fEGarch}}.
}
\examples{
locpol_spec()
locpol_spec(poly_order = 1)
locpol_spec(kernel_order = 2)

}
\references{
\itemize{
\item{Feng, Y., Gries, T., Letmathe, S., & Schulz, D. (2022). The smoots Package in R for Semiparametric Modeling of
Trend Stationary Time Series. The R Journal,
14(1), 182-195. URL: https://journal.r-project.org/articles/RJ-2022-017/.}
\item{Letmathe, S., Beran, J., & Feng, Y. (2023). An extended exponential SEMIFAR model with application
in R. Communications in Statistics - Theory and Methods,
53(22), 7914–7926. DOI: 10.1080/03610926.2023.2276049.}
}
}
