% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/despike_3D.R
\name{despike_3D}
\alias{despike_3D}
\title{3dDespike from AFNI}
\usage{
despike_3D(Yt, c1 = 2.5, c2 = 4)
}
\arguments{
\item{Yt}{The data vector.}

\item{c1}{spike threshold. Default: \code{2.5}.}

\item{c2}{upper range of the acceptable deviation from the fit. Default:
\code{4}.}
}
\description{
Identify and interpolate outliers. See
\href{https://afni.nimh.nih.gov/pub/dist/doc/program_help/3dDespike.html}{the
AFNI documentation for 3dDespike} for additional information.
}
\examples{
if (requireNamespace("fda", quietly=TRUE) && requireNamespace("quantreg", quietly=TRUE)) {
 y <- rnorm(99) + cos(seq(99)/15)*3
 y[20] <- 20
 despike_3D(y)
}

}
