% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mat.R
\name{unvec_mat}
\alias{unvec_mat}
\title{Transform vector data to image}
\usage{
unvec_mat(x, mask, fill_value = NA)
}
\arguments{
\item{x}{\eqn{v \times p} matrix, where \eqn{v} is the number of
voxels within a mask and \eqn{p} is the number of vectors to transform into
matrix images.}

\item{mask}{\eqn{m \times n} logical matrix in which \code{v}
entries are \code{TRUE} and the rest are \code{FALSE}.}

\item{fill_value}{Out-of-mask value in the output image. Default:
\code{NA}.}
}
\value{
A list of masked values from \code{x}
}
\description{
From a \eqn{v \times p} matrix of vectorized data and an \eqn{m \times n}
image mask with \eqn{v} in-mask locations, create a list of \eqn{p}
\eqn{m \times n} data arrays in which the mask locations are filled
in with the vectorized data values.

Consider using \code{abind::abind} to merge the result into a single
array.
}
\examples{
x <- unvec_mat(
 cbind(seq(3), seq(2,4), seq(3,5)), 
 matrix(c(rep(TRUE, 3), FALSE), ncol=2),
 0
)
y <- array(c(1,2,3,0,2,3,4,0,3,4,5,0), dim=c(2,2,3))
stopifnot(identical(x[[1]], y[,,1]))
stopifnot(identical(x[[2]], y[,,2]))
stopifnot(identical(x[[3]], y[,,3]))

}
