% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-check_table_values.R
\name{get_duplicated_cols}
\alias{get_duplicated_cols}
\title{Extract columns that have same values in a tibble}
\usage{
get_duplicated_cols(tbl)
}
\arguments{
\item{tbl}{R object(dataframe or tibble) of the input tibble}
}
\value{
A tibble indicating which columns which values is the same in the tibble
}
\description{
This helper function extracts the names of the columns in a tibble having
identical values for all observations.
}
\examples{
{

library(dplyr)
mtcars_duplicated <-
 mtcars \%>\%
 mutate(
  cyl_2 = cyl,
  cyl_3 = cyl,
  mpg_2 = mpg)

 get_duplicated_cols(mtcars_duplicated)

}

}
