% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_shape_add.R
\name{fabric_shape_add}
\alias{fabric_shape_add}
\title{Add a shape object to a preexisting canvas element}
\usage{
fabric_shape_add(
  cid,
  shapeId,
  shape = "Rect",
  left = "100",
  top = "100",
  fill = "red",
  width = 200,
  height = 200,
  angle = 0,
  opacity = 1,
  strokecolor = "darkblue",
  strokewidth = 5,
  selectable = TRUE,
  radius = NULL
)
}
\arguments{
\item{cid}{the id of the canvas element you want to add your shape to}

\item{shapeId}{the id of the shape object}

\item{shape}{the shape of the object. Choices include 'Circle', 'Triangle' and 'Rect'. Defaults to 'Rect'}

\item{left}{the shape's position from the left relative to the canvas element. Defaults to 100}

\item{top}{the shape's position from the top relative to the canvas element. Defaults to 100}

\item{fill}{the color of the shape. Defaults to 'red'}

\item{width}{the width of the shape. Defaults to 200}

\item{height}{the height of the shape. Defaults to 200}

\item{angle}{the angle of rotation of the shape. Defaults to 0 (no rotation)}

\item{opacity}{the opacity of the shape. Defaults to 1}

\item{strokecolor}{the stroke color of the shape. Defaults to 'darkblue'}

\item{strokewidth}{the stroke width of the shape. Defaults to 5.}

\item{selectable}{logical. If TRUE, the user can modify interactively the shape. Defaults to TRUE}

\item{radius}{Mandatory if the chosen shape is a 'Circle'. Defaults to NULL}
}
\value{
a shape object inside a preexisting canvas element
}
\description{
Add a shape object to a preexisting canvas element
}
\examples{

if (interactive()) {

ui <- fluidPage(

use_fabric(),

fabric_shape(cid = "canvas",
             shapeId = "shape1",
             shape = "Rect",
             left = 130,
             top = 200),

fabric_shape_add(cid = "canvas",
                 shapeId = "shapo",
                 shape = "Circle",
                 radius = 30,
                 left = 100,
                 top = 100),

fabric_shape_add(cid = "canvas",
                 shapeId = "shapa",
                 shape = "Circle",
                 radius = 30,
                 left = 200,
                 top = 100),

fabric_shape_add(cid = "canvas",
                 shapeId = "shapox",
                 shape = "Circle",
                 radius = 30,
                 left = 300,
                 top = 100),

fabric_shape_add(cid = "canvas",
                 shapeId = "shapor",
                 shape = "Circle",
                 radius = 30,
                 left = 300,
                 top = 100)

)


server <- function(input, output) {}

shinyApp(ui = ui, server = server)

}
}
