# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title ConfigurationAccount
#' @description ConfigurationAccount Class
#' @format An \code{R6Class} generator object
#' @field benchmarkCode  character [optional]
#'
#' @field benchmarkName  character [optional]
#'
#' @field maxEndDate  character [optional]
#'
#' @field minStartDate  character [optional]
#'
#' @field lockingDate  character [optional]
#'
#' @field name  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
ConfigurationAccount <- R6::R6Class(
  'ConfigurationAccount',
  public = list(
    `benchmarkCode` = NULL,
    `benchmarkName` = NULL,
    `maxEndDate` = NULL,
    `minStartDate` = NULL,
    `lockingDate` = NULL,
    `name` = NULL,
    initialize = function(`benchmarkCode`=NULL, `benchmarkName`=NULL, `maxEndDate`=NULL, `minStartDate`=NULL, `lockingDate`=NULL, `name`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`benchmarkCode`)) {
        stopifnot(is.character(`benchmarkCode`), length(`benchmarkCode`) == 1)
        self$`benchmarkCode` <- `benchmarkCode`
      }
      if (!is.null(`benchmarkName`)) {
        stopifnot(is.character(`benchmarkName`), length(`benchmarkName`) == 1)
        self$`benchmarkName` <- `benchmarkName`
      }
      if (!is.null(`maxEndDate`)) {
        stopifnot(is.character(`maxEndDate`), length(`maxEndDate`) == 1)
        self$`maxEndDate` <- `maxEndDate`
      }
      if (!is.null(`minStartDate`)) {
        stopifnot(is.character(`minStartDate`), length(`minStartDate`) == 1)
        self$`minStartDate` <- `minStartDate`
      }
      if (!is.null(`lockingDate`)) {
        stopifnot(is.character(`lockingDate`), length(`lockingDate`) == 1)
        self$`lockingDate` <- `lockingDate`
      }
      if (!is.null(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
    },
    toJSON = function() {
      ConfigurationAccountObject <- list()
      if (!is.null(self$`benchmarkCode`)) {
        ConfigurationAccountObject[['benchmarkCode']] <-
          self$`benchmarkCode`
      }
      if (!is.null(self$`benchmarkName`)) {
        ConfigurationAccountObject[['benchmarkName']] <-
          self$`benchmarkName`
      }
      if (!is.null(self$`maxEndDate`)) {
        ConfigurationAccountObject[['maxEndDate']] <-
          self$`maxEndDate`
      }
      if (!is.null(self$`minStartDate`)) {
        ConfigurationAccountObject[['minStartDate']] <-
          self$`minStartDate`
      }
      if (!is.null(self$`lockingDate`)) {
        ConfigurationAccountObject[['lockingDate']] <-
          self$`lockingDate`
      }
      if (!is.null(self$`name`)) {
        ConfigurationAccountObject[['name']] <-
          self$`name`
      }

      ConfigurationAccountObject
    },
    fromJSON = function(ConfigurationAccountJson) {
      ConfigurationAccountObject <- jsonlite::fromJSON(ConfigurationAccountJson)
      if (!is.null(ConfigurationAccountObject$`benchmarkCode`)) {
        self$`benchmarkCode` <- ConfigurationAccountObject$`benchmarkCode`
      }
      if (!is.null(ConfigurationAccountObject$`benchmarkName`)) {
        self$`benchmarkName` <- ConfigurationAccountObject$`benchmarkName`
      }
      if (!is.null(ConfigurationAccountObject$`maxEndDate`)) {
        self$`maxEndDate` <- ConfigurationAccountObject$`maxEndDate`
      }
      if (!is.null(ConfigurationAccountObject$`minStartDate`)) {
        self$`minStartDate` <- ConfigurationAccountObject$`minStartDate`
      }
      if (!is.null(ConfigurationAccountObject$`lockingDate`)) {
        self$`lockingDate` <- ConfigurationAccountObject$`lockingDate`
      }
      if (!is.null(ConfigurationAccountObject$`name`)) {
        self$`name` <- ConfigurationAccountObject$`name`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`benchmarkCode`)) {
        sprintf(
        '"benchmarkCode":
          "%s"
                ',
        self$`benchmarkCode`
        )},
        if (!is.null(self$`benchmarkName`)) {
        sprintf(
        '"benchmarkName":
          "%s"
                ',
        self$`benchmarkName`
        )},
        if (!is.null(self$`maxEndDate`)) {
        sprintf(
        '"maxEndDate":
          "%s"
                ',
        self$`maxEndDate`
        )},
        if (!is.null(self$`minStartDate`)) {
        sprintf(
        '"minStartDate":
          "%s"
                ',
        self$`minStartDate`
        )},
        if (!is.null(self$`lockingDate`)) {
        sprintf(
        '"lockingDate":
          "%s"
                ',
        self$`lockingDate`
        )},
        if (!is.null(self$`name`)) {
        sprintf(
        '"name":
          "%s"
                ',
        self$`name`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(ConfigurationAccountJson) {
      ConfigurationAccountObject <- jsonlite::fromJSON(ConfigurationAccountJson)
      self$`benchmarkCode` <- ConfigurationAccountObject$`benchmarkCode`
      self$`benchmarkName` <- ConfigurationAccountObject$`benchmarkName`
      self$`maxEndDate` <- ConfigurationAccountObject$`maxEndDate`
      self$`minStartDate` <- ConfigurationAccountObject$`minStartDate`
      self$`lockingDate` <- ConfigurationAccountObject$`lockingDate`
      self$`name` <- ConfigurationAccountObject$`name`
      self
    }
  )
)
