% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_fairness_object.R
\name{expand_fairness_object}
\alias{expand_fairness_object}
\title{Expand Fairness Object}
\usage{
expand_fairness_object(
  x,
  scale = FALSE,
  drop_metrics_with_na = FALSE,
  fairness_metrics = NULL
)
}
\arguments{
\item{x}{object of class \code{fairness_object}}

\item{scale}{logical, if \code{TRUE} standardized.}

\item{drop_metrics_with_na}{logical, if \code{TRUE} metrics with NA will be omitted}

\item{fairness_metrics}{character, vector of fairness metrics names indicating from which expand.}
}
\value{
object of class \code{expand_fairness_object}. It is a \code{data.frame} with scores for each metric and model.
}
\description{
Unfold fairness object to 3 columns (metrics, label, score) to construct better base for visualization.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

expand_fairness_object(fobject, drop_metrics_with_na = TRUE)

}
