% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fairness_heatmap.R
\name{plot.fairness_heatmap}
\alias{plot.fairness_heatmap}
\title{Plot Heatmap}
\usage{
\method{plot}{fairness_heatmap}(
  x,
  ...,
  midpoint = NULL,
  title = NULL,
  subtitle = NULL,
  text = TRUE,
  text_size = 3,
  flip_axis = FALSE
)
}
\arguments{
\item{x}{\code{fairness_heatmap}}

\item{...}{other \code{fairness_heatmap} objects}

\item{midpoint}{numeric, midpoint on gradient scale}

\item{title}{character, title of the plot}

\item{subtitle}{character, subtitle of the plot}

\item{text}{logical, default \code{TRUE} means it shows values on tiles}

\item{text_size}{numeric, size of text}

\item{flip_axis}{logical, whether to change axis with metrics on axis with models}
}
\value{
list of \code{ggplot2} objects
}
\description{
Heatmap shows all parity loss metrics across all models while displaying similarity between variables (in form of dendograms). All metrics are visible. Some have identical values
as it should be in terms of their parity loss (eg. TPR parity loss == FNR parity loss, because TPR = 1 - FNR ).
NA's in metrics are gray.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200,
                           num.threads = 1,
                           seed = 1)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

 # same explainers with different cutoffs for female
fobject <- fairness_check(explainer_lm, explainer_rf, fobject,
                          protected = german$Sex,
                          privileged = "male",
                          cutoff = list(female = 0.4),
                          label = c("lm_2", "rf_2"))


fh <- fairness_heatmap(fobject)

plot(fh)


}
