% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makelists.R
\name{makelist_targets}
\alias{makelist_targets}
\alias{get_target}
\alias{remove_target}
\alias{add_target}
\title{Manipulate \code{makelist} Targets}
\usage{
get_target(makelist, alias)

remove_target(makelist, target)

add_target(
  makelist,
  target,
  code,
  prerequisites = NULL,
  prerequisite_to = NULL,
  sink = NULL,
  alias = sub("\\\\.(Rout|log)$", "", basename(target))
)
}
\arguments{
\item{makelist}{A list for
\code{\link[fakemake:make]{fakemake::make}}.}

\item{alias}{The alias for the new target.}

\item{target}{The target to remove from \code{makelist}.}

\item{code}{The code for the new target.}

\item{prerequisites}{The prerequisites for the new target.}

\item{prerequisite_to}{The targets the new target is a prerequisite to.
Set to \code{\link{TRUE}} to add it as a prerequisite to all existing
targets.}

\item{sink}{The sink for the new target.}
}
\value{
A list (the target requested).

A list for
\code{\link[fakemake:make]{fakemake::make}}.

A list for
\code{\link[fakemake:make]{fakemake::make}}.
}
\description{
Get, add or remove targets from/to a \code{makelist}.
}
\section{Functions}{
\itemize{
\item \code{get_target}: Get a single target from a \code{makelist} by
alias.

\item \code{remove_target}: Remove a target and all its appearances as
other targets' dependencies from a \code{makelist}.

\item \code{add_target}: Add a Target to an Existing \code{makelist}.
}}

\examples{
ml <- provide_make_list(type  = "cran")
length(ml)
t <- get_target(ml, "check")
ml <- remove_target(ml, t[["target"]])
length(ml)
ml <- add_target(ml, target = t[["target"]], code = t[["code"]],
                sink = t[["sink"]])
all.equal(ml[[1]], provide_make_list(type  = "cran")[[1]])
}
