% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has.R
\name{has_ctl}
\alias{has_ctl}
\alias{has_sgr}
\title{Checks for Presence of Control Sequences}
\usage{
has_ctl(x, ctl = "all", warn = getOption("fansi.warn"), which)

has_sgr(x, warn = getOption("fansi.warn"))
}
\arguments{
\item{x}{a character vector or object that can be coerced to character.}

\item{ctl}{character, which \emph{Control Sequences} should be treated
specially. See the "_ctl vs. _sgr" section for details.
\itemize{
\item "nl": newlines.
\item "c0": all other "C0" control characters (i.e. 0x01-0x1f, 0x7F), except
for newlines and the actual ESC (0x1B) character.
\item "sgr": ANSI CSI SGR sequences.
\item "csi": all non-SGR ANSI CSI sequences.
\item "esc": all other escape sequences.
\item "all": all of the above, except when used in combination with any of the
above, in which case it means "all but".
}}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}

\item{which}{character, deprecated in favor of \code{ctl}.}
}
\value{
logical of same length as \code{x}; NA values in \code{x} result in NA values
in return
}
\description{
\code{has_ctl} checks for any \emph{Control Sequence}, whereas \code{has_sgr} checks only
for ANSI CSI SGR sequences.  You can check for different types of sequences
with the \code{ctl} parameter.
}
\section{_ctl vs. _sgr}{


The \verb{*_ctl} versions of the functions treat all \emph{Control Sequences} specially
by default.  Special treatment is context dependent, and may include
detecting them and/or computing their display/character width as zero.  For
the SGR subset of the ANSI CSI sequences, \code{fansi} will also parse, interpret,
and reapply the text styles they encode if needed.  You can modify whether a
\emph{Control Sequence} is treated specially with the \code{ctl} parameter.  You can
exclude a type of \emph{Control Sequence} from special treatment by combining
"all" with that type of sequence (e.g. \code{ctl=c("all", "nl")} for special
treatment of all \emph{Control Sequences} \strong{but} newlines).  The \verb{*_sgr} versions
only treat ANSI CSI SGR sequences specially, and are equivalent to the
\verb{*_ctl} versions with the \code{ctl} parameter set to "sgr".
}

\examples{
has_ctl("hello world")
has_ctl("hello\nworld")
has_ctl("hello\nworld", "sgr")
has_ctl("hello\033[31mworld\033[m", "sgr")
has_sgr("hello\033[31mworld\033[m")
has_sgr("hello\nworld")
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results.
}
