% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GOF.R
\name{GOF}
\alias{GOF}
\alias{plot.GOF}
\alias{print.GOF}
\title{Goodness of Fit Distance}
\usage{
GOF(data, model, ...)

\method{print}{GOF}(x, ncases = 10, digits = 5, ...)

\method{plot}{GOF}(x, y = NULL, main = "Goodness of Fit Distance",
  type = c("p", "h"), ylab = "GOF", absolute = FALSE, ...)
}
\arguments{
\item{data}{matrix or data.frame}

\item{model}{if a single numeric number declares number of factors to extract in
exploratory factor analysis (requires complete dataset, i.e., no missing).
If \code{class(model)} is a sem (semmod), or lavaan (character),
then a confirmatory approach is performed instead. Finally, if the model is defined with
\code{mirt::mirt.model()} then distances will be computed for categorical data with the
mirt package}

\item{...}{additional parameters to be passed}

\item{x}{an object of class \code{GOF}}

\item{ncases}{number of extreme cases to display}

\item{digits}{number of digits to round in the printed result}

\item{y}{a \code{NULL} value ignored by the plotting function}

\item{main}{the main title of the plot}

\item{type}{type of plot to use, default displays points and lines}

\item{ylab}{the y label of the plot}

\item{absolute}{logical; use absolute values instead of deviations?}
}
\description{
Compute Goodness of Fit distances between models when removing the \eqn{i_{th}} case.
}
\details{
Note that \code{GOF} is not limited to confirmatory factor analysis and
can apply to nearly any model being studied
where detection of influential observations is important.
}
\examples{
\dontrun{

#run all GOF functions using multiple cores
setCluster()

#Exploratory
nfact <- 3
(GOFresult <- GOF(holzinger, nfact))
(GOFresult.outlier <- GOF(holzinger.outlier, nfact))
plot(GOFresult)
plot(GOFresult.outlier)

#-------------------------------------------------------------------
#Confirmatory with sem
model <- sem::specifyModel()
	  F1 -> Remndrs,    lam11
	  F1 -> SntComp,    lam21
	  F1 -> WrdMean,    lam31
	  F2 -> MissNum,    lam42
	  F2 -> MxdArit,    lam52
	  F2 -> OddWrds,    lam62
	  F3 -> Boots,      lam73
	  F3 -> Gloves,     lam83
	  F3 -> Hatchts,    lam93
	  F1 <-> F1,   NA,     1
	  F2 <-> F2,   NA,     1
	  F3 <-> F3,   NA,     1

(GOFresult <- GOF(holzinger, model))
(GOFresult.outlier <- GOF(holzinger.outlier, model))
plot(GOFresult)
plot(GOFresult.outlier)

#-------------------------------------------------------------------
#Confirmatory with lavaan
model <- 'F1 =~  Remndrs + SntComp + WrdMean
F2 =~ MissNum + MxdArit + OddWrds
F3 =~ Boots + Gloves + Hatchts'

(GOFresult <- GOF(holzinger, model, orthogonal=TRUE))
(GOFresult.outlier <- GOF(holzinger.outlier, model, orthogonal=TRUE))
plot(GOFresult)
plot(GOFresult.outlier)

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\references{
Flora, D. B., LaBrish, C. & Chalmers, R. P. (2012). Old and new ideas for data screening and assumption testing for
exploratory and confirmatory factor analysis. \emph{Frontiers in Psychology, 3}, 1-21.
}
\seealso{
\code{\link{gCD}}, \code{\link{LD}}, \code{\link{obs.resid}},
  \code{\link{robustMD}}, \code{\link{setCluster}}
}
\keyword{cooks}

