/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.HashSet;
import java.util.Set;
import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.BadModelException;
import jfm.model.BoundaryComponent;
import jfm.model.DitchLengthComponent;
import jfm.model.ELSOption;
import jfm.model.ELSOptionComponent;
import jfm.model.Farm;
import jfm.model.Types;

public class BoundaryMaintenanceComponent
extends ELSOptionComponent {
    public static Set<Types.ELSCode> elscodes = new HashSet<Types.ELSCode>();

    public BoundaryMaintenanceComponent(double eb1cost, double eb2cost, double eb3cost, double eb6cost, double eb10cost) {
        super(ModelComponent.MCType.ELSBOUNDARIES);
        this.requireObjective(Types.ObjectiveType.HEDGEROWS);
        this.requireObjective(Types.ObjectiveType.DITCHES);
        this.requireObjective(Types.ObjectiveType.PROFIT);
        this.addConstraintBuilder(new ConserveHedgeLengthConstraint());
        this.addConstraintBuilder(new ConserveDitchLengthConstraint());
        this.options.put(Types.ELSCode.EB1, new ELSOption(Types.ELSCode.EB1, eb1cost, Types.ELSCode.EB1.defaultPoints));
        this.options.put(Types.ELSCode.EB2, new ELSOption(Types.ELSCode.EB2, eb1cost, Types.ELSCode.EB2.defaultPoints));
        this.options.put(Types.ELSCode.EB3, new ELSOption(Types.ELSCode.EB3, eb1cost, Types.ELSCode.EB3.defaultPoints));
        this.options.put(Types.ELSCode.EB6, new ELSOption(Types.ELSCode.EB6, eb1cost, Types.ELSCode.EB6.defaultPoints));
        this.options.put(Types.ELSCode.EB10, new ELSOption(Types.ELSCode.EB10, eb1cost, Types.ELSCode.EB10.defaultPoints));
    }

    public ModelComponent copy() {
        return null;
    }

    protected void initializeStructure() throws BadModelException {
        for (Types.ELSCode ecode : elscodes) {
            MatrixVariable newVariable = new MatrixVariable(-((ELSOption)this.options.get((Object)((Object)ecode))).costPerUnit, 0.0, 0.0, LPX.LPX_LO, LPX.LPX_CV, this.matrix.numCols(), Types.ObjectiveType.PROFIT);
            newVariable.setTag(ecode.toString());
            this.matrix.addVariable(newVariable);
            ((ELSOption)this.options.get((Object)ecode)).registerVariable(newVariable, 0);
            ((ELSOption)this.options.get((Object)ecode)).registerParent(this);
        }
    }

    protected String name() {
        return null;
    }

    public void setFormulaVariables() {
    }

    protected void updateStructure() {
        for (ELSOption op : this.options.values()) {
            op.updateStructure(this);
        }
        this.structureUpdateDone();
    }

    static {
        elscodes.add(Types.ELSCode.EB1);
        elscodes.add(Types.ELSCode.EB2);
        elscodes.add(Types.ELSCode.EB3);
        elscodes.add(Types.ELSCode.EB6);
        elscodes.add(Types.ELSCode.EB10);
    }

    public final class ConserveDitchLengthConstraint
    extends ConstraintBuilder {
        public ConserveDitchLengthConstraint() {
            super(ConstraintBuilder.CBType.ELSDITCHLENGTH, ModelComponent.MCType.ELSBOUNDARIES);
        }

        protected void build() {
            Farm farm = BoundaryMaintenanceComponent.this.getParent();
            int row = BoundaryMaintenanceComponent.this.matrix.numRows();
            MatrixRow rp = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, "ELS Hedges and Ditches", "ELS Hedges and Ditches");
            BoundaryMaintenanceComponent.this.matrix.addRow(rp);
            ++row;
            DitchLengthComponent ditchesmc = (DitchLengthComponent)farm.getModelComponent(ModelComponent.MCType.DITCHES);
            rp.addElement(new MatrixElement(ditchesmc.getBoundaryCounterColumn(), 1.0));
            rp.addElement(new MatrixElement(((ELSOption)BoundaryMaintenanceComponent.this.options.get((Object)Types.ELSCode.EB6)).getDependentColumn(0), -1.0));
            rp.addElement(new MatrixElement(((ELSOption)BoundaryMaintenanceComponent.this.options.get((Object)Types.ELSCode.EB10)).getDependentColumn(0), -1.0));
        }
    }

    public final class ConserveHedgeLengthConstraint
    extends ConstraintBuilder {
        public ConserveHedgeLengthConstraint() {
            super(ConstraintBuilder.CBType.ELSHEDGELENGTH, ModelComponent.MCType.ELSBOUNDARIES);
        }

        protected void build() {
            Farm farm = BoundaryMaintenanceComponent.this.getParent();
            int row = BoundaryMaintenanceComponent.this.matrix.numRows();
            MatrixRow rp = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, "ELS Conserve Hedges", "ELS Conserve Hedges");
            BoundaryMaintenanceComponent.this.matrix.addRow(rp);
            ++row;
            BoundaryComponent hedgesmc = (BoundaryComponent)farm.getModelComponent(ModelComponent.MCType.HEDGEROWS);
            rp.addElement(new MatrixElement(hedgesmc.getBoundaryCounterColumn(), 1.0));
            rp.addElement(new MatrixElement(((ELSOption)BoundaryMaintenanceComponent.this.options.get((Object)Types.ELSCode.EB1)).getDependentColumn(0), -1.0));
            rp.addElement(new MatrixElement(((ELSOption)BoundaryMaintenanceComponent.this.options.get((Object)Types.ELSCode.EB2)).getDependentColumn(0), -1.0));
            rp.addElement(new MatrixElement(((ELSOption)BoundaryMaintenanceComponent.this.options.get((Object)Types.ELSCode.EB3)).getDependentColumn(0), -1.0));
            rp.addElement(new MatrixElement(((ELSOption)BoundaryMaintenanceComponent.this.options.get((Object)Types.ELSCode.EB10)).getDependentColumn(0), -1.0));
        }
    }
}

