/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.HashMap;
import java.util.Map;
import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.Crop;
import jfm.model.CroppingComponent;
import jfm.model.Farm;
import jfm.model.LandUseComponent;
import jfm.model.Location;
import jfm.model.Types;

public class CropComplexityComponent
extends ModelComponent {
    private double threshold = 0.0;
    private Map<Types.CropType, MatrixVariable> counter = new HashMap<Types.CropType, MatrixVariable>();

    public CropComplexityComponent(double threshold_) {
        super(ModelComponent.MCType.CROPCOMPLEXITY);
        this.threshold = threshold_;
        this.requireObjective(Types.ObjectiveType.CROPCOMPLEXITY);
        this.addConstraintBuilder(new CropCounterMinConstraint());
        this.addConstraintBuilder(new CropCounterMaxConstraint());
    }

    public CropComplexityComponent copy() {
        return new CropComplexityComponent(this.threshold);
    }

    protected void initializeStructure() {
        this.counter.clear();
        Farm farm = this.getParent();
        CroppingComponent cropping = farm.cropping;
        Location location = this.getParent().location();
        for (Types.CropType ct : cropping.baseCropTypes()) {
            MatrixVariable newVariable = new MatrixVariable(1.0, 0.0, 1.0, LPX.LPX_DB, LPX.LPX_IV, this.matrix.numCols(), Types.ObjectiveType.CROPCOMPLEXITY);
            newVariable.setTag(ct.xmlname + "_cnt");
            this.matrix.addVariable(newVariable);
            this.counter.put(ct, newVariable);
        }
    }

    public void setFormulaVariables() {
    }

    protected String name() {
        return "CropComplexity";
    }

    protected void updateStructure() {
    }

    public final class CropCounterMaxConstraint
    extends ConstraintBuilder {
        public CropCounterMaxConstraint() {
            super(ConstraintBuilder.CBType.CROPCOUNTERMAX, ModelComponent.MCType.CROPCOMPLEXITY);
        }

        protected void build() {
            int row = CropComplexityComponent.this.matrix.numRows();
            CroppingComponent cropping = CropComplexityComponent.this.getParent().cropping;
            LandUseComponent landUse = CropComplexityComponent.this.getParent().landUse;
            for (Map.Entry entry : CropComplexityComponent.this.counter.entrySet()) {
                MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, "CropComplexity", this.type().tag);
                CropComplexityComponent.this.matrix.addRow(rowpointer);
                ++row;
                rowpointer.addElement(new MatrixElement(((MatrixVariable)entry.getValue()).column(), landUse.getArea()));
                Crop cp = cropping.getCrop((Types.CropType)((Object)entry.getKey()));
                for (Crop.CropCopy cpcpy : cp.getYearCopies()) {
                    rowpointer.addElement(new MatrixElement(cpcpy.getDependentColumn(0), -1.0));
                }
            }
        }
    }

    public final class CropCounterMinConstraint
    extends ConstraintBuilder {
        public CropCounterMinConstraint() {
            super(ConstraintBuilder.CBType.CROPCOUNTERMIN, ModelComponent.MCType.CROPCOMPLEXITY);
        }

        protected void build() {
            int row = CropComplexityComponent.this.matrix.numRows();
            CroppingComponent cropping = CropComplexityComponent.this.getParent().cropping;
            LandUseComponent landUse = CropComplexityComponent.this.getParent().landUse;
            for (Map.Entry entry : CropComplexityComponent.this.counter.entrySet()) {
                MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, "CropComplexity", this.type().tag);
                CropComplexityComponent.this.matrix.addRow(rowpointer);
                ++row;
                rowpointer.addElement(new MatrixElement(((MatrixVariable)entry.getValue()).column(), -1.0 * CropComplexityComponent.this.threshold * landUse.getArea()));
                Crop cp = cropping.getCrop((Types.CropType)((Object)entry.getKey()));
                for (Crop.CropCopy cpcpy : cp.getYearCopies()) {
                    rowpointer.addElement(new MatrixElement(cpcpy.getDependentColumn(0), 1.0));
                }
            }
        }
    }
}

