% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_colour.R
\name{compare_colour}
\alias{compare_colour}
\title{Calculate the distance between colours}
\usage{
compare_colour(from, to = NULL, from_space, to_space = from_space,
  method = "euclidean", white_from = "D65", white_to = white_from)
}
\arguments{
\item{from, to}{Numeric matrices with colours to compare - the format is the
same as that for \code{\link[=convert_colour]{convert_colour()}}. If \code{to} is not set \code{from} will be
compared with itself and only the upper triangle will get calculated}

\item{from_space, to_space}{The colour space of \code{from} and \code{to} respectively.
\code{to_space} defaults to be the same as \code{from_space}.}

\item{method}{The method to use for comparison. Either \code{'euclidean'},
\code{'cie1976'}, \code{'cie94'}, \code{'cie2000'}, or \code{'cmc'}}

\item{white_from, white_to}{The white reference of the from and to colour
space. Will only have an effect for relative colour spaces such as Lab and
luv. Any value accepted by \code{\link[=as_white_ref]{as_white_ref()}} allowed.}
}
\value{
A numeric matrix with the same number of rows as colours in \code{from}
and the same number of columns as colours in \code{to}. If \code{to} is not given, only
the upper triangle will be returned.
}
\description{
There are many ways to measure the distance between colours. \code{farver}
provides 5 different algorithms, ranging from simple euclidean distance in
RGB space, to different perceptual measures such as CIE2000.
}
\examples{
r <- t(col2rgb(rainbow(10)))
h <- t(col2rgb(heat.colors(15)))

# Compare two sets of colours
compare_colour(r, h, 'rgb', method = 'cie2000')

# Compare a set of colours with itself
compare_colour(r, from_space = 'rgb', method = 'cmc')
}
