% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_annual_flow_timing.R
\name{plot_annual_flow_timing}
\alias{plot_annual_flow_timing}
\title{Plot annual timing of flows}
\usage{
plot_annual_flow_timing(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  percent_total = c(25, 33.3, 50, 75),
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  include_title = FALSE
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{percent_total}{Numeric vector of percents of total annual flows to determine dates. Default \code{c(25,33.3,50,75)}.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank or set well before start date (i.e.
\code{1800}) to use from the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank or set well after end date (i.e.
\code{2100}) to use up to the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank or set to \code{NULL} to include all years.}

\item{months}{Numeric vector of months to include in analysis. For example, \code{3} for March, \code{6:8} for Jun-Aug or 
\code{c(10:12,1)} for first four months (Oct-Jan) when \code{water_year_start = 10} (Oct). Default summarizes all 
months (\code{1:12}).}

\item{include_title}{Logical value to indicate adding the group/station number to the plot, if provided. Default \code{FALSE}.}
}
\value{
A list of ggplot2 objects with the following for each station provided:
  \item{Annual_Flow_Timing}{a plot that contains each n-percent of total volumetric discharge}
  Default plots on each object:   
  \item{DoY_25pct_TotalQ}{day of year of 25-percent of total volumetric discharge}
  \item{DoY_33.3pct_TotalQ}{day of year of 33.3-percent of total volumetric discharge}
  \item{DoY_50pct_TotalQ}{day of year of 50-percent of total volumetric discharge}
  \item{DoY_75pct_TotalQ}{day of year of 75-percent of total volumetric discharge}
}
\description{
Plots the timing (day of year and date) of portions of total annual flow of daily flow 
   values from a daily streamflow data set. Calculates statistics from all values from complete years, unless specified. 
   Data calculated using \code{calc_annual_flow_timing()} function. Returns a list of plots.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Plot annual flow timing statistics with default percent totals
plot_annual_flow_timing(station_number = "08NM116") 

# Plot annual flow timing with custom percent totals
plot_annual_flow_timing(station_number = "08NM116",
                        percent_total = 50,
                        start_year = 1980)
                        
}
}
\references{
\itemize{
 \item{Barnett, T.P., Pierce, D.W., Hidalgo, H.G., Bonfils, C., Santer, B.D., Das, T., Bala, G., Wood, A.W.,
       Nozawa, T., Mirin, A.A., Cayan, D.R., Dettinger, M.D., 2008. Human-Induced Clanges in the Hydrology of 
       the Western United States. Science 319, 1080-1083.}
       }
}
\seealso{
\code{\link{calc_annual_flow_timing}}
}
