% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fll_pred.R
\name{pred.sglmm}
\alias{pred.sglmm}
\title{Model Predictions}
\usage{
pred.sglmm(fit.sglmm, data, coords, ntrial = 1, offset = NA)
}
\arguments{
\item{fit.sglmm}{a list from \code{fsglmm}}

\item{data}{a data frame to be predicted by the model.}

\item{coords}{coordinates for prediction}

\item{ntrial}{a numeric vector of the total number of trials ( binomial )}

\item{offset}{a numeric vector indicating a known component to be included in the linear predictor for predictions.}
}
\value{
a vector of predicted mean parameters. (e.g. probabilities for binomial case)
}
\description{
\code{pred.sglmm} is a function for predictions from the results of \code{fsglmm}.
}
\examples{

## the result from fsglmm, data to be predicted, and the coordinates for prediction is required.

\donttest{
result <- fsglmm(Y~-1+X1+X2, kappa=2.5, inits = startinit, data = data,coords = coords,
family = "binomial", ntrial = 1, offset = NA,method.optim = "CG",method.integrate = "NR",rank = 50)
pred.sglmm(fit.sglmm=result,data=X.pred,)
}


}
