% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eim-class.R
\name{save_eim}
\alias{save_eim}
\alias{save_eim()}
\title{Save an \code{eim} object to a file}
\usage{
save_eim(object, filename, ...)
}
\arguments{
\item{object}{An \code{eim} object.}

\item{filename}{A character string specifying the file path, including the desired file extension (\code{.rds}, \code{.json}, or \code{.csv}).}

\item{...}{Additional arguments (currently unused but included for compatibility).}
}
\value{
The function does not return anything explicitly but saves the object to the specified file.
}
\description{
This function saves an \code{eim} object to a specified file format. Supported formats are
\strong{RDS}, \strong{JSON}, and \strong{CSV}. The function dynamically extracts and saves all available
attributes when exporting to JSON. If the \code{prob} field exists, it is saved when using CSV;
otherwise, it yields an error.
}
\details{
\itemize{
\item If the file extension is \strong{RDS}, the entire object is saved using \code{saveRDS()}.
\item If the file extension is \strong{JSON}, all available attributes of the object are stored in JSON format.
\item If the file extension is \strong{CSV}:
\itemize{
\item If the object contains a \code{prob} field, only that field is saved as a CSV.
\item Otherwise, returns an error.
}
}
}
\examples{
\donttest{
model <- eim(X = matrix(1:9, 3, 3), W = matrix(1:9, 3, 3))

model <- run_em(model)

td <- tempdir()
out_rds <- file.path(td, "model_results.rds")
out_json <- file.path(td, "model_results.json")
out_csv <- file.path(td, "model_results.csv")

# Save as RDS
save_eim(model, filename = out_rds)

# Save as JSON
save_eim(model, filename = out_json)

# Save as CSV
save_eim(model, filename = out_csv)

# Remove the files
files <- c(out_rds, out_json, out_csv)
file.remove(files)
}

}
\seealso{
The \link{eim} object implementation.
}
