% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.r
\name{global,GRaster-method}
\alias{global,GRaster-method}
\alias{global}
\alias{global,missing-method}
\title{Summary statistics for GRasters}
\usage{
\S4method{global}{GRaster}(x, fun = "mean", probs = seq(0, 1, 0.25), ...)

\S4method{global}{missing}(x, ...)
}
\arguments{
\item{x}{A \code{GRaster} or missing.  If missing, then a vector of all of the accepted function names is returned.}

\item{fun}{Character vector: The name of the function(s):
\itemize{
\item \code{"*"}: All of the functions below.
\item \code{"cv"}: Sample coefficient of variation (expressed as a proportion of the mean).
\item \code{"cvpop"}: Population coefficient of variation (expressed as a proportion of the mean).
\item \code{"max"} and \code{"min"}: Highest and lowest values across non-\code{NA} cells. NB: \code{\link[=minmax]{minmax()}} is faster.
\item \code{"mean"} (default): Average.
\item \code{"meanAbs"}: Mean of absolute values.
\item \code{"median"}: Median.
\item \code{"quantile"}: Quantile (see also argument \code{probs}).
\item \code{"range"}: Range. Note that following \code{\link[terra:global]{terra::global()}}, the minimum and maximum are reported, not the actual range.
\item \code{"sd"}: Sample standard deviation (same as \code{\link[stats:sd]{stats::sd()}}).
\item \code{"sdpop"}: Population standard deviation.
\item \code{"sum"}: Sum.
\item \code{"var"}: Sample variance (same as \code{\link[stats:cor]{stats::var()}}).
\item \code{"varpop"}: Population variance.
}}

\item{probs}{Numeric within the range from 0 to 1: Quantile(s) at which to calculate \code{quantile}.}

\item{...}{Other arguments (unused).}
}
\value{
If \code{x} is missing, the function returns a character vector of all accepted function names. If \code{x} is a \code{GRaster}, a data frame with the specified statistics is returned.
}
\description{
\code{global()} calculates a summary statistic across all the cells of a \code{GRaster}. It returns a single value for each layer of the raster.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster:
elev <- fast(madElev)

# What functions can we use with global()?
global()

# Calculate global statistics:
global(elev, fun = c("mean", "var", "varpop"))
global(elev, "quantile", probs = c(0.25, 0.5, 0.75))

global(elev, "*") # calculate all available functions

}
}
\seealso{
\code{\link[terra:global]{terra::global()}} and \strong{GRASS} module \code{r.univar}
}
