% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.eigen.median.R
\name{metric.eigen.median}
\alias{metric.eigen.median}
\title{Median Eigenvalue Centrality}
\usage{
metric.eigen.median(g)
}
\arguments{
\item{g}{The input network.}
}
\value{
A real constant.
}
\description{
Calculate the median eigenvalue centrality of a graph.
}
\details{
\code{metric.eigen.median} calculates the median eigenvalue centrality score of graph \emph{g}.
}
\examples{
\dontrun{
x <-  net.erdos.renyi.gnp(1000, 0.01)
metric.eigen.median(x)}
}
\references{
Bonacich, Phillip, and Paulette Lloyd. "Eigenvector-like measures of centrality for asymmetric relations." Social networks 23, no. 3 (2001): 191-201.

Borgatti, Stephen P. "Centrality and network flow." Social networks 27, no. 1 (2005): 55-71.
}
\author{
Xu Dong, Nazrul Shaikh.
}
