% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simulate_pos}
\alias{simulate_pos}
\title{Simulate several points of stability}
\usage{
simulate_pos(
  x_pop,
  y_pop,
  n_studies,
  sample_size_min,
  sample_size_max,
  replace,
  lower_limit,
  upper_limit
)
}
\arguments{
\item{x_pop}{First vector of population.}

\item{y_pop}{Second vector of population.}

\item{n_studies}{How many studies to conduct.}

\item{sample_size_min}{Minimum sample size to start in corridor of
stability.}

\item{sample_size_max}{How many participants to draw at maximum.}

\item{replace}{Whether drawing samples is with replacement or not.}

\item{lower_limit}{Lower limit of corridor of stability.}

\item{upper_limit}{Upper limit of corridor of stability.}
}
\value{
Vector of sample sizes at which corridor of stability was reached.
}
\description{
Runs several simulations and returns the points of stability, which can then
be further processed to calculate the critical point of stability.
}
\examples{
pop <- fastpos::create_pop(0.5, 1000000)
simulate_pos(pop[,1], pop[,2], 100, 20, 1000, TRUE, 0.4, 0.6)
}
