% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_word_distance}
\alias{get_word_distance}
\title{Distance between two words}
\usage{
get_word_distance(model, w1, w2)
}
\arguments{
\item{model}{trained fastText model. Null if train a new model.}

\item{w1}{first word to compare}

\item{w2}{second word to compare}
}
\value{
a \code{scalar} with the distance
}
\description{
Distance is equal to \code{1 - cosine}
}
\examples{

library(fastrtext)
model_test_path <- system.file("extdata", "model_unsupervised_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
get_word_distance(model, "time", "timing")

}
