context('gurobi')
suppressMessages(library(tidyverse))

test_that('toy model 1', {
  skip_if_not_installed('gurobi')
  library(gurobi)
  
  model <- reactiontbl_to_gurobi(dplyr::data_frame(
    abbreviation = c('one', 'two'),
    equation = c('alpha -> beta', 'gamma -> delta'),
    lowbnd = c(-1,-1),
    uppbnd = c(3,3),
    obj_coef = c(1,0)))
  
  result <- gurobi(model, params = list(OutputFlag=0))
  expect_equal(result$status, 'OPTIMAL')
  expect_equal(result$objval, 0)
})

test_that('toy model 2', {
  skip_if_not_installed('gurobi')
  library(gurobi)
  
  model <- reactiontbl_to_gurobi(dplyr::data_frame(
    abbreviation = c('one', 'two'),
    equation = c('alpha -> ', ' <-> alpha'),
    lowbnd = c(-1,-1),
    uppbnd = c(3,3),
    obj_coef = c(1,0)))
  
  result <- gurobi(model, params = list(OutputFlag=0))
  expect_equal(result$status, 'OPTIMAL')
  expect_equal(result$objval, 3)
})