% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{fct_pattern_replace}
\alias{fct_pattern_replace}
\title{Replace Patterns in Factor Levels}
\usage{
fct_pattern_replace(factor_vec, pattern, replacement)
}
\arguments{
\item{factor_vec}{A factor vector to modify.}

\item{pattern}{A regular expression pattern to match.}

\item{replacement}{A string to replace the matched patterns.}
}
\value{
A factor vector with modified levels.
}
\description{
Replaces substrings in factor levels that match a pattern with a replacement string.
}
\examples{
# Example factor vector
factor_vec <- factor(c('user_123', 'admin_456', 'guest_789'))

# Replace numeric IDs with 'ID'
fct_pattern_replace(factor_vec, pattern = '[0-9]+', replacement = 'ID')
}
\author{
Kai Guo
}
