% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{Kernel.integrate}
\alias{Kernel.integrate}
\alias{IKer.norm}
\alias{IKer.cos}
\alias{IKer.epa}
\alias{IKer.tri}
\alias{IKer.quar}
\alias{IKer.unif}
\title{Integrate Smoothing Kernels.}
\usage{
Kernel.integrate(u, Ker = Ker.norm, a = -1)
}
\arguments{
\item{u}{data}

\item{Ker}{Type of Kernel. By default normal kernel.}

\item{a}{Lower limit of integration.}
}
\value{
Returns integrate kernel.
}
\description{
Represent integrate kernels: normal, cosine, triweight, quartic and uniform.
}
\details{
Type of integrate kernel: \tabular{ll}{ \tab Integrate Normal Kernel:
\code{IKer.norm}\cr \tab Integrate Cosine Kernel: \code{IKer.cos}\cr \tab
Integrate Epanechnikov Kernel: \code{IKer.epa}\cr \tab Integrate Triweight
Kernel: \code{IKer.tri}\cr \tab Integrate Quartic Kernel:
\code{IKer.quar}\cr \tab Integrate Uniform Kernel: \code{IKer.unif}\cr }
}
\examples{
y=qnorm(seq(.1,.9,len=100))
d=IKer.tri(y)
e=IKer.cos(y)
e2=Kernel.integrate(u=y,Ker=Ker.cos)
e-e2
f=IKer.epa(y)
f2=Kernel.integrate(u=y,Ker=Ker.epa)
f-f2
plot(d,type="l",ylab="Integrate Kernel")
lines(e,col=2,type="l")
lines(f,col=4,type="l") 

}
\references{
Ferraty, F. and Vieu, P. (2006). \emph{Nonparametric functional
data analysis.} Springer Series in Statistics, New York.

Hardle, W. \emph{Applied Nonparametric Regression}. Cambridge University
Press, 1994.
}
\seealso{
See Also as: \code{\link{Kernel}} and \link[stats]{integrate}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{kernel}
