% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCrCovYX.R
\name{GetCrCovYX}
\alias{GetCrCovYX}
\title{Functional Cross Covariance between longitudinal variable Y and longitudinal variable X}
\usage{
GetCrCovYX(bw1 = NULL, bw2 = NULL, Ly1, Lt1 = NULL, Ymu1 = NULL,
  Ly2, Lt2 = NULL, Ymu2 = NULL, useGAM = FALSE, rmDiag = FALSE,
  kern = "gauss", bwRoutine = "l-bfgs-b")
}
\arguments{
\item{bw1}{Scalar bandwidth for smoothing the cross-covariance function (if NULL it will be automatically estimated) (Y)}

\item{bw2}{Scalar bandwidth for smoothing the cross-covariance function (if NULL it will be automatically estimated) (X)}

\item{Ly1}{List of N vectors with amplitude information (Y)}

\item{Lt1}{List of N vectors with timing information (Y)}

\item{Ymu1}{Vector Q-1 Vector of length nObsGrid containing the mean function estimate (Y)}

\item{Ly2}{List of N vectors with amplitude information (X)}

\item{Lt2}{List of N vectors with timing information (X)}

\item{Ymu2}{Vector Q-1 Vector of length nObsGrid containing the mean function estimate (X)}

\item{useGAM}{Indicator to use gam smoothing instead of local-linear smoothing (semi-parametric option) (default: FALSE)}

\item{rmDiag}{Indicator to remove the diagonal element when smoothing (default: FALSE)}

\item{kern}{String specifying the kernel type (default: FALSE;  see ?FPCA for details)}

\item{bwRoutine}{String specifying the routine used to find the optimal bandwidth 'grid-search', 'bobyqa', 'l-bfgs-b' (default: 'l-bfgs-b')
If the variables Ly1 and Ly2 are in matrix form the data are assumed dense
and only the raw cross-covariance is returned. One can obtain Ymu1 and Ymu2
from \code{FPCA} and \code{ConvertSupport}.}
}
\value{
A list containing:
\item{smoothedCC}{The smoothed cross-covariance as a matrix (currently only 51 by 51)}
\item{rawCC}{The raw cross-covariance as a list}
\item{bw}{The bandwidth used for smoothing as a vector of length 2}
\item{score}{The GCV score associated with the scalar used}
\item{smoothGrid}{The grid over which the smoothed cross-covariance is evaluated}
}
\description{
Calculate the raw and the smoothed cross-covariance between functional predictors using bandwidth bw or estimate that bw using GCV.
}
\examples{
Ly1= list( rep(2.1,7), rep(2.1,3),2.1 );
Lt1 = list(1:7,1:3, 1);
Ly2 = list( rep(1.1,7), rep(1.1,3),1.1); 
Lt2 = list(1:7,1:3, 1);
Ymu1 = rep(55,7);
Ymu2 = rep(1.1,7);
AA<-GetCrCovYX(Ly1 = Ly1, Ly2= Ly2, Lt1=Lt1, Lt2=Lt2, Ymu1=Ymu1, Ymu2=Ymu2)
  
}
\references{
\cite{Yang, Wenjing, Hans-Georg Müller, and Ulrich Stadtmüller. "Functional singular component analysis." Journal of the Royal Statistical Society: Series B (Statistical Methodology) 73.3 (2011): 303-324}
}
