% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_align_functions.R
\name{pair_align_functions}
\alias{pair_align_functions}
\title{Align two functions}
\usage{
pair_align_functions(f1, f2, time, lambda = 0, method = "DP", w = 0.01,
  f1o = 0, f2o = 0)
}
\arguments{
\item{f1}{function 1}

\item{f2}{function 2}

\item{time}{sample points of functions}

\item{lambda}{controls amount of warping (default = 0)}

\item{method}{controls which optimization method (default="DP") options are
Dynamic Programming ("DP"), Coordinate Descent ("DP2"), Riemannian BFGS
("RBFGS") and Simultaneous Alignment ("SIMUL")}

\item{w}{controls LRBFGS (default = 0.01)}

\item{f1o}{initial value of f1, vector or scalar depending on q1, defaults to zero}

\item{f2o}{initial value of f2, vector or scalar depending on q1, defaults to zero}
}
\value{
Returns a list containing \item{f2tilde}{aligned f2}
\item{gam}{warping function}
}
\description{
This function aligns two functions using SRSF framework. It will align f2
to f1
}
\examples{
data("simu_data")
out = pair_align_functions(simu_data$f[,1],simu_data$f[,2],simu_data$time)
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
 May 2011. Registration of functional data using fisher-rao metric,
 arXiv:1103.3817v2 [math.ST].

Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srsf}
