% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{cartplot}
\alias{cartplot}
\title{CART Plot}
\usage{
cartplot(model, margin = 0.2, branch = 0.3, uniform = TRUE,
  fancy = TRUE, pretty = TRUE, fwidth = 0, fheight = 0, ...)
}
\arguments{
\item{model}{The decision tree.}

\item{margin}{an extra fraction of white space to leave around the borders of the tree. (Long labels sometimes get cut off by the default computation).}

\item{branch}{controls the shape of the branches from parent to child node. Any number from 0 to 1 is allowed. A value of 1 gives square shouldered branches, a value of 0 give V shaped branches, with other values being intermediate.}

\item{uniform}{if \code{TRUE}, uniform vertical spacing of the nodes is used; this may be less cluttered when fitting a large plot onto a page. The default is to use a non-uniform spacing proportional to the error in the fit.}

\item{fancy}{Logical. If \code{TRUE}, nodes are represented by ellipses (interior nodes) and rectangles (leaves) and labeled by yval. The edges connecting the nodes are labeled by left and right splits.}

\item{pretty}{an alternative to the minlength argument, see \code{\link[rpart]{labels.rpart}}.}

\item{fwidth}{Relates to option \code{fancy} and the width of the ellipses and rectangles. If \code{fwidth < 1} then it is a scaling factor (default = 0.8). If \code{fwidth > 1} then it represents the number of character widths (for current graphical device) to use.}

\item{fheight}{Relates to option \code{fancy} and the width of the ellipses and rectangles. If \code{fwidth < 1} then it is a scaling factor (default = 0.8). If \code{fwidth > 1} then it represents the number of character heights (for current graphical device) to use.}

\item{...}{Other parameters.}
}
\description{
Plot a decision tree obtained by CART.
}
\examples{
require (datasets)
data (iris)
model = CART (iris [, -5], iris [, 5])
cartplot (model)
}
\seealso{
\code{\link{CART}}, \code{\link{cartdepth}}, \code{\link{cartinfo}}, \code{\link{cartleafs}}, \code{\link{cartnodes}}
}
