% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{resplot}
\alias{resplot}
\title{Plot the studentized residuals of a linear regression model}
\usage{
resplot(model, index = NULL)
}
\arguments{
\item{model}{The model to be plotted.}

\item{index}{The index of the variable used for for the x-axis.}
}
\description{
Plot the studentized residuals of a linear regression model.
}
\examples{
require (datasets)
data (trees)
model = LINREG (trees [, -3], trees [, 3])
resplot (model) # Ordered by index
resplot (model, index = 0) # Ordered by variable "Volume" (dependant variable)
resplot (model, index = 1) # Ordered by variable "Girth" (independant variable)
resplot (model, index = 2) # Ordered by variable "Height" (independant variable)
}
