% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{distplot}
\alias{distplot}
\title{Plot a k-distance graphic}
\usage{
distplot(k, d, h = -1)
}
\arguments{
\item{k}{The \code{k} parameter.}

\item{d}{The dataset (\code{matrix} or \code{data.frame}).}

\item{h}{The y-coordinate at which a horizontal line should be drawn.}
}
\description{
Plot the distance to the k's nearest neighbours of each object in decreasing order. Mostly used to determine the \code{eps} parameter for the \code{\link[fpc]{dbscan}} function.
}
\examples{
require (datasets)
data (iris)
distplot (5, iris [, -5], h = .65)
}
\seealso{
\code{\link{DBSCAN}}, \code{\link[fpc]{dbscan}}
}
