% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{filter.rules}
\alias{filter.rules}
\title{Filtering a set of rules}
\usage{
filter.rules(
  rules,
  pattern = NULL,
  left = pattern,
  right = pattern,
  removeMatches = FALSE
)
}
\arguments{
\item{rules}{A set of rules.}

\item{pattern}{A pattern to match (antecedent and consequent): a character string.}

\item{left}{A pattern to match (antecedent only): a character string.}

\item{right}{A pattern to match (consequent only): a character string.}

\item{removeMatches}{A logical indicating whether to remove matching rules (\code{TRUE}) or to keep those (\code{FALSE}).}
}
\value{
The filtered set of rules.
}
\description{
This function facilitate the selection of a subset from a set of rules.
}
\examples{
require ("arules")
data ("Adult")
r = apriori (Adult)
filter.rules (r, right = "marital-status=")
subset (r, subset = rhs \%pin\% "marital-status=")
}
\seealso{
\code{\link[arules]{apriori}}, \code{\link[arules]{subset}}
}
