% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classical.R
\name{classical_decomposition}
\alias{classical_decomposition}
\title{Classical Seasonal Decomposition by Moving Averages}
\usage{
classical_decomposition(formula, type = c("additive", "multiplicative"), ...)
}
\arguments{
\item{formula}{Decomposition specification (see "Specials" section).}

\item{type}{The type of seasonal component. Can be abbreviated.}

\item{...}{Other arguments passed to \code{\link[stats:decompose]{stats::decompose()}}.}
}
\value{
A \code{\link[fabletools:dable]{fabletools::dable()}} containing the decomposed trend, seasonality
and remainder from the classical decomposition.
}
\description{
Decompose a time series into seasonal, trend and irregular components
  using moving averages.  Deals with additive or multiplicative
  seasonal component.
}
\details{
The additive model used is:
  \deqn{Y_t = T_t + S_t + e_t}{Y[t] = T[t] + S[t] + e[t]}
  The multiplicative model used is:
  \deqn{Y_t = T_t\,S_t\, e_t}{Y[t] = T[t] * S[t] * e[t]}

  The function first determines the trend component using a moving
  average (if \code{filter} is \code{NULL}, a symmetric window with
  equal weights is used), and removes it from the time series.  Then,
  the seasonal figure is computed by averaging, for each time unit, over
  all periods.  The seasonal figure is then centered.   Finally, the error
  component is determined by removing trend and seasonal figure
  (recycled as needed) from the original time series.

  This only works well if \code{x} covers an integer number of complete
  periods.
}
\section{Specials}{


\subsection{season}{
The \code{season} special is used to specify seasonal attributes of the decomposition.
\preformatted{
season(period = NULL)
}

\tabular{ll}{
\code{period}   \tab The periodic nature of the seasonality. This can be either a number indicating the number of observations in each seasonal period, or text to indicate the duration of the seasonal window (for example, annual seasonality would be "1 year").
}
}
}

\examples{
as_tsibble(USAccDeaths) \%>\%
  model(classical_decomposition(value)) \%>\%
  components()

as_tsibble(USAccDeaths) \%>\%
  model(classical_decomposition(value ~ season(12), type = "mult")) \%>\%
  components()

}
