% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observation.R
\name{observation}
\alias{observation}
\title{Get 'observation' table}
\usage{
observation(
  data.set,
  variable,
  stack = FALSE,
  missing = list(coord = "keep", time = "keep", data = "keep"),
  standardization = list(crs = NULL, time.format = NULL, units = FALSE, round = FALSE),
  harmonization = list(harmonize = FALSE, level = 2),
  progress = TRUE,
  verbose = TRUE,
  febr.repo = NULL
)
}
\arguments{
\item{data.set}{Character vector indicating the identification code of one or more data sets.
Use \code{data.set = "all"} to download all data sets.}

\item{variable}{(optional) Character vector indicating one or more variables. Accepts only
general identification codes, e.g. \code{"ferro"} and \code{"carbono"}. If missing, then a set of standard
identification variables is downloaded. Use \code{variable = "all"} to download all variables. See
\sQuote{Details} for more information.}

\item{stack}{(optional) Logical value indicating if tables from different datasets should be
stacked on a single table for output. Requires \code{standardization = list(units = TRUE)} -- see
below. Defaults to \code{stack = FALSE}, the output being a list of tables.}

\item{missing}{(optional) List with named sub-arguments indicating what should be done with an
observation missing spatial coordinates, \code{coord}, date of observation, \code{time}, or data on
variables, \code{data}. Options are \code{"keep"} (default) and \code{"drop"}.}

\item{standardization}{(optional) List with named sub-arguments indicating how to perform data
standardization.
\itemize{
\item \code{crs} Character string indicating the EPSG code of the coordinate reference system (CRS)
to which spatial coordinates should be transformed. For example, \code{crs = "EPSG:4674"}, i.e.
SIRGAS 2000, the standard CRS for Brazil. Defaults to \code{crs = NULL}, i.e. no transformation
is performed.
\item \code{time.format} Character string indicating how to format dates. For example,
\code{time.format = "\%d-\%m-\%Y"}, i.e. dd-mm-yyyy such as in 31-12-2001. Defaults to
\code{time.format = NULL}, i.e. no formatting is performed. See \code{\link[base:as.Date]{base::as.Date()}} for more
details.

\item \code{units} Logical value indicating if the measurement unit(s) of the continuous variable(s)
should be converted to the standard measurement unit(s). Defaults to \code{units = FALSE}, i.e. no
conversion is performed. See \code{\link[=dictionary]{dictionary()}} for more information.

\item \code{round} Logical value indicating if the values of the continuous variable(s) should be
rounded to the standard number of decimal places. Requires \code{units = TRUE}. Defaults to
\code{round = FALSE}, i.e. no rounding is performed. See \code{\link[=dictionary]{dictionary()}} for more
information.
}}

\item{harmonization}{(optional) List with named sub-arguments indicating if and how to perform
data harmonization.
\itemize{
\item \code{harmonize} Logical value indicating if data should be harmonized. Defaults to
\code{harmonize = FALSE}, i.e. no harmonization is performed.

\item \code{level} Integer value indicating the number of levels of the identification code of the
variable(s) that should be considered for harmonization. Defaults to \code{level = 2}. See
\sQuote{Details} for more information.
}}

\item{progress}{(optional) Logical value indicating if a download progress bar should be displayed.}

\item{verbose}{(optional) Logical value indicating if informative messages should be displayed. Generally
useful to identify datasets with inconsistent data. Please report to \email{febr-forum@googlegroups.com}
if you find any issue.}

\item{febr.repo}{(optional) Defaults to the remote file directory of the Federal University of
Technology - Paraná at \url{https://cloud.utfpr.edu.br/index.php/s/Df6dhfzYJ1DDeso}.
Alternatively, a local directory path can be informed if the user has a local copy of the data
repository.}
}
\value{
A \code{list} of \code{data.frame}s or a \code{data.frame} with, possibly standardize or harmonized,
data of the chosen variable(s) of the chosen dataset(s).
}
\description{
Download data from the 'observation' ("observacao") table of one or more datasets
published in \href{https://www.pedometria.org/febr/}{Data Repository of the Brazilian Soil}.
This table includes data such as latitude, longitude, date of observation, underlying geology,
land use and vegetation, local topography, soil classification, and much more.
}
\details{
\subsection{Default variables}{
Default variables (fields) present in the 'observation' table are as follows:
\itemize{
\item \code{dataset_id}. Identification code of the dataset in the FEBR to which an observation
belongs.
\item \code{evento_id_febr}. Identification code of an observation in a dataset.
\item \code{evento_data}. Date (dd-mm-yyyy) in which an observation was made.
\item \code{coord_datum}. EPSG code of the coordinate reference system.
\item \code{coord_longitude}. Longitude (deg) or easting (m).
\item \code{coord_latitude}. Latitude (deg) or northing (m).
\item \code{coord_precisao}. Precision with which the spatial coordinates were determined (m).
\item \code{coord_fonte}. Source of the spatial coordinates.
\item \code{pais_id}. Code (ISO 3166-1 alpha-2) of the county where an observation was made.
\item \code{estado_sigla}. Acronym of the Brazilian federative unit where an observation was made.
\item \code{municipio_nome}. Name of the Brazilian municipality where as observation was made.
\item \code{subamostra_quanti}. Number of sub samples taken (used to indicate composite sampling).
\item \code{amostra_area}. Sampling area (used to indicate areal or block sampling).
}
Further details about the content of the default variables (fields) can be found in
\url{https://docs.google.com/document/d/1Bqo8HtitZv11TXzTviVq2bI5dE6_t_fJt0HE-l3IMqM}
(in Portuguese).
}
\subsection{Harmonization}{
Data harmonization consists of converting the values of a variable determined using some method
\emph{B} so that they are (approximately) equivalent to the values that would have been obtained if
the standard method \emph{A} had been used instead. For example, converting carbon content values
obtained using a wet combustion method to the standard dry combustion method is data
harmonization.

A heuristic data harmonization procedure is implemented in the \strong{febr} package. It consists of
grouping variables based on a chosen number of levels of their identification code. For example,
consider a variable with an identification code composed of four levels, \code{aaa_bbb_ccc_ddd}, where
\code{aaa} is the first level and \code{ddd} is the fourth level. Now consider a related variable,
\code{aaa_bbb_eee_fff}. If the harmonization is to consider all four coding levels (\code{level = 4}),
then these two variables will remain coded as separate variables. But if \code{level = 2}, then both
variables will be re-coded as \code{aaa_bbb}, thus becoming the same variable.
}
}
\examples{
if (interactive()) {
res <- observation(data.set = "ctb0013")

# Download two data sets and standardize CRS
res <- observation(
  data.set = paste("ctb000", 4:5, sep = ""),
  variable = "taxon",
  standardization = list(crs = "EPSG:4674"))

# Try to download a data set that is not available yet
res <- observation(data.set = "ctb0020")

# Try to download a non existing data set
#res <- observation(data.set = "ctb0000")

}
}
\seealso{
\code{\link[=readFEBR]{readFEBR()}}, \code{\link[=layer]{layer()}}, \code{\link[=dictionary]{dictionary()}}, \code{\link[=unit]{unit()}}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
